/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.giraph.comm.netty.ChannelRotater;
import org.apache.giraph.comm.netty.InboundByteCounter;
import org.apache.giraph.comm.netty.OutboundByteCounter;
import org.apache.giraph.comm.netty.SaslNettyClient;
import org.apache.giraph.comm.netty.handler.AddressRequestIdGenerator;
import org.apache.giraph.comm.netty.handler.ClientRequestId;
import org.apache.giraph.comm.netty.handler.RequestEncoder;
import org.apache.giraph.comm.netty.handler.RequestInfo;
import org.apache.giraph.comm.netty.handler.ResponseClientHandler;
import org.apache.giraph.comm.netty.handler.SaslClientHandler;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.SaslTokenMessageRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.utils.PipelineUtils;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.utils.ThreadUtils;
import org.apache.giraph.utils.TimedLogger;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class NettyClient {
    public static final String LIMIT_NUMBER_OF_OPEN_REQUESTS = "giraph.waitForRequestsConfirmation";
    public static final boolean LIMIT_NUMBER_OF_OPEN_REQUESTS_DEFAULT = false;
    public static final String MAX_NUMBER_OF_OPEN_REQUESTS = "giraph.maxNumberOfOpenRequests";
    public static final int MAX_NUMBER_OF_OPEN_REQUESTS_DEFAULT = 10000;
    public static final int MAX_REQUESTS_TO_LIST = 10;
    public static final int MAX_DESTINATION_TASK_IDS_TO_LIST = 10;
    public static final int MAX_CONNECTION_MILLISECONDS_DEFAULT = 30000;
    public static final AttributeKey<SaslNettyClient> SASL = AttributeKey.valueOf((String)"saslNettyClient");
    private static final Logger LOG = Logger.getLogger(NettyClient.class);
    private final Mapper.Context context;
    private final Bootstrap bootstrap;
    private final ConcurrentMap<InetSocketAddress, ChannelRotater> addressChannelMap = new MapMaker().makeMap();
    private final Map<Integer, InetSocketAddress> taskIdAddressMap = new MapMaker().makeMap();
    private final ConcurrentMap<ClientRequestId, RequestInfo> clientRequestIdRequestInfoMap;
    private final int channelsPerServer;
    private final InboundByteCounter inboundByteCounter = new InboundByteCounter();
    private final OutboundByteCounter outboundByteCounter = new OutboundByteCounter();
    private final int sendBufferSize;
    private final int receiveBufferSize;
    private final boolean limitNumberOfOpenRequests;
    private final int maxNumberOfOpenRequests;
    private final int maxConnectionFailures;
    private final int maxRequestMilliseconds;
    private final int waitingRequestMsecs;
    private final TimedLogger requestLogger = new TimedLogger(15000, LOG);
    private final EventLoopGroup workerGroup;
    private final AddressRequestIdGenerator addressRequestIdGenerator = new AddressRequestIdGenerator();
    private final TaskInfo myTaskInfo;
    private final int maxPoolSize;
    private final int maxResolveAddressAttempts;
    private final boolean useExecutionGroup;
    private final EventExecutorGroup executionGroup;
    private final String handlerToUseExecutionGroup;
    private final AtomicLong lastTimeCheckedRequestsForProblems = new AtomicLong(0L);
    private final LogOnErrorChannelFutureListener logErrorListener = new LogOnErrorChannelFutureListener();

    public NettyClient(Mapper.Context context, final ImmutableClassesGiraphConfiguration conf, TaskInfo myTaskInfo, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.context = context;
        this.myTaskInfo = myTaskInfo;
        this.channelsPerServer = GiraphConstants.CHANNELS_PER_SERVER.get(conf);
        this.sendBufferSize = GiraphConstants.CLIENT_SEND_BUFFER_SIZE.get(conf);
        this.receiveBufferSize = GiraphConstants.CLIENT_RECEIVE_BUFFER_SIZE.get(conf);
        this.limitNumberOfOpenRequests = conf.getBoolean(LIMIT_NUMBER_OF_OPEN_REQUESTS, false);
        if (this.limitNumberOfOpenRequests) {
            this.maxNumberOfOpenRequests = conf.getInt(MAX_NUMBER_OF_OPEN_REQUESTS, 10000);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NettyClient: Limit number of open requests to " + this.maxNumberOfOpenRequests));
            }
        } else {
            this.maxNumberOfOpenRequests = -1;
        }
        this.maxRequestMilliseconds = GiraphConstants.MAX_REQUEST_MILLISECONDS.get(conf);
        this.maxConnectionFailures = GiraphConstants.NETTY_MAX_CONNECTION_FAILURES.get(conf);
        this.waitingRequestMsecs = GiraphConstants.WAITING_REQUEST_MSECS.get(conf);
        this.maxPoolSize = GiraphConstants.NETTY_CLIENT_THREADS.get(conf);
        this.maxResolveAddressAttempts = GiraphConstants.MAX_RESOLVE_ADDRESS_ATTEMPTS.get(conf);
        this.clientRequestIdRequestInfoMap = new MapMaker().concurrencyLevel(this.maxPoolSize).makeMap();
        this.handlerToUseExecutionGroup = GiraphConstants.NETTY_CLIENT_EXECUTION_AFTER_HANDLER.get(conf);
        this.useExecutionGroup = GiraphConstants.NETTY_CLIENT_USE_EXECUTION_HANDLER.get(conf);
        if (this.useExecutionGroup) {
            int executionThreads = GiraphConstants.NETTY_CLIENT_EXECUTION_THREADS.get(conf);
            this.executionGroup = new DefaultEventExecutorGroup(executionThreads, ThreadUtils.createThreadFactory("netty-client-exec-%d", exceptionHandler));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NettyClient: Using execution handler with " + executionThreads + " threads after " + this.handlerToUseExecutionGroup + "."));
            }
        } else {
            this.executionGroup = null;
        }
        this.workerGroup = new NioEventLoopGroup(this.maxPoolSize, ThreadUtils.createThreadFactory("netty-client-worker-%d", exceptionHandler));
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize)).option(ChannelOption.SO_RCVBUF, (Object)this.receiveBufferSize)).option(ChannelOption.ALLOCATOR, (Object)conf.getNettyAllocator())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (conf.authenticate()) {
                    LOG.info((Object)"Using Netty with authentication.");
                    PipelineUtils.addLastWithExecutorCheck("clientInboundByteCounter", (ChannelHandler)NettyClient.this.inboundByteCounter, NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    if (conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionDecoder", (ChannelHandler)conf.getNettyCompressionDecoder(), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("clientOutboundByteCounter", (ChannelHandler)NettyClient.this.outboundByteCounter, NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    if (conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionEncoder", (ChannelHandler)conf.getNettyCompressionEncoder(), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("length-field-based-frame-decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(1024, 0, 4, 0, 4), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("request-encoder", (ChannelHandler)new RequestEncoder(conf), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("sasl-client-handler", (ChannelHandler)new SaslClientHandler(conf), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("response-handler", (ChannelHandler)new ResponseClientHandler(NettyClient.this.clientRequestIdRequestInfoMap, conf), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                } else {
                    LOG.info((Object)"Using Netty without authentication.");
                    PipelineUtils.addLastWithExecutorCheck("clientInboundByteCounter", (ChannelHandler)NettyClient.this.inboundByteCounter, NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    if (conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionDecoder", (ChannelHandler)conf.getNettyCompressionDecoder(), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("clientOutboundByteCounter", (ChannelHandler)NettyClient.this.outboundByteCounter, NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    if (conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionEncoder", (ChannelHandler)conf.getNettyCompressionEncoder(), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("fixed-length-frame-decoder", (ChannelHandler)new FixedLengthFrameDecoder(13), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("request-encoder", (ChannelHandler)new RequestEncoder(conf), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("response-handler", (ChannelHandler)new ResponseClientHandler(NettyClient.this.clientRequestIdRequestInfoMap, conf), NettyClient.this.handlerToUseExecutionGroup, NettyClient.this.executionGroup, (Channel)ch);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void connectAllAddresses(Collection<? extends TaskInfo> tasks) {
        ArrayList waitingConnectionList = Lists.newArrayListWithCapacity((int)(tasks.size() * this.channelsPerServer));
        for (TaskInfo taskInfo : tasks) {
            this.context.progress();
            InetSocketAddress address = this.taskIdAddressMap.get(taskInfo.getTaskId());
            if (address == null || !address.getHostName().equals(taskInfo.getHostname()) || address.getPort() != taskInfo.getPort()) {
                address = NettyClient.resolveAddress(this.maxResolveAddressAttempts, taskInfo.getInetSocketAddress());
                this.taskIdAddressMap.put(taskInfo.getTaskId(), address);
            }
            if (address == null || address.getHostName() == null || address.getHostName().isEmpty()) {
                throw new IllegalStateException("connectAllAddresses: Null address in addresses " + tasks);
            }
            if (address.isUnresolved()) {
                throw new IllegalStateException("connectAllAddresses: Unresolved address " + address);
            }
            if (this.addressChannelMap.containsKey(address)) continue;
            for (int i = 0; i < this.channelsPerServer; ++i) {
                ChannelFuture connectionFuture = this.bootstrap.connect((SocketAddress)address);
                waitingConnectionList.add(new ChannelFutureAddress(connectionFuture, address, taskInfo.getTaskId()));
            }
        }
        int failures = 0;
        boolean bl = false;
        while (failures < this.maxConnectionFailures) {
            void var4_7;
            ArrayList nextCheckFutures = Lists.newArrayList();
            for (ChannelFutureAddress waitingConnection : waitingConnectionList) {
                this.context.progress();
                ChannelFuture future = waitingConnection.future;
                ProgressableUtils.awaitChannelFuture(future, (Progressable)this.context);
                if (!future.isSuccess()) {
                    LOG.warn((Object)("connectAllAddresses: Future failed to connect with " + waitingConnection.address + " with " + failures + " failures because of " + future.cause()));
                    ChannelFuture connectionFuture = this.bootstrap.connect((SocketAddress)waitingConnection.address);
                    nextCheckFutures.add(new ChannelFutureAddress(connectionFuture, waitingConnection.address, waitingConnection.taskId));
                    ++failures;
                    continue;
                }
                Channel channel = future.channel();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("connectAllAddresses: Connected to " + channel.remoteAddress() + ", open = " + channel.isOpen()));
                }
                if (channel.remoteAddress() == null) {
                    throw new IllegalStateException("connectAllAddresses: Null remote address!");
                }
                ChannelRotater rotater = (ChannelRotater)this.addressChannelMap.get(waitingConnection.address);
                if (rotater == null) {
                    ChannelRotater newRotater = new ChannelRotater(waitingConnection.taskId);
                    rotater = this.addressChannelMap.putIfAbsent(waitingConnection.address, newRotater);
                    if (rotater == null) {
                        rotater = newRotater;
                    }
                }
                rotater.addChannel(future.channel());
                ++var4_7;
            }
            LOG.info((Object)("connectAllAddresses: Successfully added " + (waitingConnectionList.size() - nextCheckFutures.size()) + " connections, (" + (int)var4_7 + " total connected) " + nextCheckFutures.size() + " failed, " + failures + " failures total."));
            if (nextCheckFutures.isEmpty()) break;
            waitingConnectionList = nextCheckFutures;
        }
        if (failures >= this.maxConnectionFailures) {
            throw new IllegalStateException("connectAllAddresses: Too many failures (" + failures + ").");
        }
    }

    public void authenticate() {
        LOG.info((Object)"authenticate: NettyClient starting authentication with servers.");
        for (InetSocketAddress address : this.addressChannelMap.keySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("authenticate: Authenticating with address:" + address));
            }
            ChannelRotater channelRotater = (ChannelRotater)this.addressChannelMap.get(address);
            for (Channel channel : channelRotater.getChannels()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("authenticate: Authenticating with server on channel: " + channel));
                }
                this.authenticateOnChannel(channelRotater.getTaskId(), channel);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("authenticate: NettyClient successfully authenticated with " + this.addressChannelMap.size() + " server" + (this.addressChannelMap.size() != 1 ? "s" : "") + " - continuing with normal work."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticateOnChannel(Integer taskId, Channel channel) {
        try {
            SaslNettyClient saslNettyClient = (SaslNettyClient)channel.attr(SASL).get();
            if (channel.attr(SASL).get() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("authenticateOnChannel: Creating saslNettyClient now for channel: " + channel));
                }
                saslNettyClient = new SaslNettyClient();
                channel.attr(SASL).set((Object)saslNettyClient);
            }
            if (!saslNettyClient.isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"authenticateOnChannel: Waiting for authentication to complete..");
                }
                SaslTokenMessageRequest saslTokenMessage = saslNettyClient.firstToken();
                this.sendWritableRequest(taskId, saslTokenMessage);
                try {
                    Object object = saslNettyClient.getAuthenticated();
                    synchronized (object) {
                        while (!saslNettyClient.isComplete()) {
                            saslNettyClient.getAuthenticated().wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"authenticateOnChannel: Interrupted while waiting for authentication.");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("authenticateOnChannel: Authentication on channel: " + channel + " has completed successfully."));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("authenticateOnChannel: Failed to authenticate with server due to error: " + e));
        }
    }

    public void stop() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"stop: Halting netty client");
        }
        int channelCount = 0;
        for (ChannelRotater channelRotater : this.addressChannelMap.values()) {
            channelCount += channelRotater.size();
        }
        final int done = channelCount;
        final AtomicInteger count = new AtomicInteger(0);
        for (ChannelRotater channelRotater : this.addressChannelMap.values()) {
            channelRotater.closeChannels(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) {
                    NettyClient.this.context.progress();
                    if (count.incrementAndGet() == done) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("stop: reached wait threshold, " + done + " connections closed, releasing " + "resources now."));
                        }
                        NettyClient.this.workerGroup.shutdownGracefully();
                        if (NettyClient.this.executionGroup != null) {
                            NettyClient.this.executionGroup.shutdownGracefully();
                        }
                    }
                }
            });
        }
        ProgressableUtils.awaitTerminationFuture((EventExecutorGroup)this.workerGroup, (Progressable)this.context);
        if (this.executionGroup != null) {
            ProgressableUtils.awaitTerminationFuture(this.executionGroup, (Progressable)this.context);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"stop: Netty client halted");
        }
    }

    private Channel getNextChannel(InetSocketAddress remoteServer) {
        Channel channel = ((ChannelRotater)this.addressChannelMap.get(remoteServer)).nextChannel();
        if (channel == null) {
            throw new IllegalStateException("getNextChannel: No channel exists for " + remoteServer);
        }
        if (channel.isActive()) {
            return channel;
        }
        if (((ChannelRotater)this.addressChannelMap.get(remoteServer)).removeChannel(channel)) {
            LOG.warn((Object)("getNextChannel: Unlikely event that the channel " + channel + " was already removed!"));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("getNextChannel: Fixing disconnected channel to " + remoteServer + ", open = " + channel.isOpen() + ", " + "bound = " + channel.isRegistered()));
        }
        int reconnectFailures = 0;
        while (reconnectFailures < this.maxConnectionFailures) {
            ChannelFuture connectionFuture = this.bootstrap.connect((SocketAddress)remoteServer);
            ProgressableUtils.awaitChannelFuture(connectionFuture, (Progressable)this.context);
            if (connectionFuture.isSuccess()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("getNextChannel: Connected to " + remoteServer + "!"));
                }
                ((ChannelRotater)this.addressChannelMap.get(remoteServer)).addChannel(connectionFuture.channel());
                return connectionFuture.channel();
            }
            LOG.warn((Object)("getNextChannel: Failed to reconnect to " + remoteServer + " on attempt " + ++reconnectFailures + " out of " + this.maxConnectionFailures + " max attempts, sleeping for 5 secs"), connectionFuture.cause());
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"getNextChannel: Unexpected interrupted exception", (Throwable)e);
            }
        }
        throw new IllegalStateException("getNextChannel: Failed to connect to " + remoteServer + " in " + reconnectFailures + " connect attempts");
    }

    public void sendWritableRequest(Integer destTaskId, WritableRequest request) {
        InetSocketAddress remoteServer = this.taskIdAddressMap.get(destTaskId);
        if (this.clientRequestIdRequestInfoMap.isEmpty()) {
            this.inboundByteCounter.resetAll();
            this.outboundByteCounter.resetAll();
        }
        boolean registerRequest = true;
        if (request.getType() == RequestType.SASL_TOKEN_MESSAGE_REQUEST) {
            registerRequest = false;
        }
        Channel channel = this.getNextChannel(remoteServer);
        RequestInfo newRequestInfo = new RequestInfo(remoteServer, request);
        if (registerRequest) {
            request.setClientId(this.myTaskInfo.getTaskId());
            request.setRequestId(this.addressRequestIdGenerator.getNextRequestId(remoteServer));
            ClientRequestId clientRequestId = new ClientRequestId(destTaskId, request.getRequestId());
            RequestInfo oldRequestInfo = this.clientRequestIdRequestInfoMap.putIfAbsent(clientRequestId, newRequestInfo);
            if (oldRequestInfo != null) {
                throw new IllegalStateException("sendWritableRequest: Impossible to have a previous request id = " + request.getRequestId() + ", " + "request info of " + oldRequestInfo);
            }
        }
        ChannelFuture writeFuture = channel.write((Object)request);
        newRequestInfo.setWriteFuture(writeFuture);
        writeFuture.addListener((GenericFutureListener)this.logErrorListener);
        if (this.limitNumberOfOpenRequests && this.clientRequestIdRequestInfoMap.size() > this.maxNumberOfOpenRequests) {
            this.waitSomeRequests(this.maxNumberOfOpenRequests);
        }
    }

    public void waitAllRequests() {
        this.waitSomeRequests(0);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("waitAllRequests: Finished all requests. " + this.inboundByteCounter.getMetrics() + "\n" + this.outboundByteCounter.getMetrics()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSomeRequests(int maxOpenRequests) {
        while (this.clientRequestIdRequestInfoMap.size() > maxOpenRequests) {
            this.logInfoAboutOpenRequests(maxOpenRequests);
            ConcurrentMap<ClientRequestId, RequestInfo> concurrentMap = this.clientRequestIdRequestInfoMap;
            synchronized (concurrentMap) {
                if (this.clientRequestIdRequestInfoMap.size() <= maxOpenRequests) {
                    break;
                }
                try {
                    this.clientRequestIdRequestInfoMap.wait(this.waitingRequestMsecs);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"waitSomeRequests: Got unexpected InterruptedException", (Throwable)e);
                }
            }
            this.context.progress();
            this.checkRequestsForProblems();
        }
    }

    private void logInfoAboutOpenRequests(int maxOpenRequests) {
        if (LOG.isInfoEnabled() && this.requestLogger.isPrintable()) {
            LOG.info((Object)("logInfoAboutOpenRequests: Waiting interval of " + this.waitingRequestMsecs + " msecs, " + this.clientRequestIdRequestInfoMap.size() + " open requests, waiting for it to be <= " + maxOpenRequests + ", " + this.inboundByteCounter.getMetrics() + "\n" + this.outboundByteCounter.getMetrics()));
            if (this.clientRequestIdRequestInfoMap.size() < 10) {
                for (Map.Entry entry : this.clientRequestIdRequestInfoMap.entrySet()) {
                    LOG.info((Object)("logInfoAboutOpenRequests: Waiting for request " + entry.getKey() + " - " + entry.getValue()));
                }
            }
            HashMap openRequestCounts = Maps.newHashMap();
            for (ClientRequestId clientRequestId : this.clientRequestIdRequestInfoMap.keySet()) {
                int taskId = clientRequestId.getDestinationTaskId();
                Integer currentCount = (Integer)openRequestCounts.get(taskId);
                openRequestCounts.put(taskId, (currentCount == null ? 0 : currentCount) + 1);
            }
            ArrayList sorted = Lists.newArrayList(openRequestCounts.entrySet());
            Collections.sort(sorted, new Comparator<Map.Entry<Integer, Integer>>(){

                @Override
                public int compare(Map.Entry<Integer, Integer> entry1, Map.Entry<Integer, Integer> entry2) {
                    int value2;
                    int value1 = entry1.getValue();
                    return value1 < (value2 = entry2.getValue().intValue()) ? 1 : (value1 == value2 ? 0 : -1);
                }
            });
            StringBuilder message = new StringBuilder();
            message.append("logInfoAboutOpenRequests: ");
            int itemsToPrint = Math.min(10, sorted.size());
            for (int i = 0; i < itemsToPrint; ++i) {
                message.append(((Map.Entry)sorted.get(i)).getValue()).append(" requests for taskId=").append(((Map.Entry)sorted.get(i)).getKey()).append(", ");
            }
            LOG.info((Object)message);
        }
    }

    private void checkRequestsForProblems() {
        RequestInfo requestInfo;
        long lastTimeChecked = this.lastTimeCheckedRequestsForProblems.get();
        if (System.currentTimeMillis() < lastTimeChecked + (long)this.waitingRequestMsecs) {
            return;
        }
        if (!this.lastTimeCheckedRequestsForProblems.compareAndSet(lastTimeChecked, System.currentTimeMillis())) {
            return;
        }
        ArrayList addedRequestIds = Lists.newArrayList();
        ArrayList addedRequestInfos = Lists.newArrayList();
        for (Map.Entry entry : this.clientRequestIdRequestInfoMap.entrySet()) {
            requestInfo = (RequestInfo)entry.getValue();
            ChannelFuture writeFuture = requestInfo.getWriteFuture();
            if (writeFuture == null || writeFuture.channel().isActive() && (!writeFuture.isDone() || writeFuture.isSuccess()) && requestInfo.getElapsedMsecs() <= (long)this.maxRequestMilliseconds) continue;
            LOG.warn((Object)("checkRequestsForProblems: Problem with request id " + entry.getKey() + " connected = " + writeFuture.channel().isActive() + ", future done = " + writeFuture.isDone() + ", " + "success = " + writeFuture.isSuccess() + ", " + "cause = " + writeFuture.cause() + ", " + "elapsed time = " + requestInfo.getElapsedMsecs() + ", " + "destination = " + writeFuture.channel().remoteAddress() + " " + requestInfo));
            addedRequestIds.add(entry.getKey());
            addedRequestInfos.add(new RequestInfo(requestInfo.getDestinationAddress(), requestInfo.getRequest()));
        }
        for (int i = 0; i < addedRequestIds.size(); ++i) {
            ClientRequestId requestId = (ClientRequestId)addedRequestIds.get(i);
            if (this.clientRequestIdRequestInfoMap.put(requestId, requestInfo = (RequestInfo)addedRequestInfos.get(i)) == null) {
                LOG.warn((Object)("checkRequestsForProblems: Request " + requestId + " completed prior to sending the next request"));
                this.clientRequestIdRequestInfoMap.remove(requestId);
            }
            InetSocketAddress remoteServer = requestInfo.getDestinationAddress();
            Channel channel = this.getNextChannel(remoteServer);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("checkRequestsForProblems: Re-issuing request " + requestInfo));
            }
            ChannelFuture writeFuture = channel.write((Object)requestInfo.getRequest());
            requestInfo.setWriteFuture(writeFuture);
            writeFuture.addListener((GenericFutureListener)this.logErrorListener);
        }
        addedRequestIds.clear();
        addedRequestInfos.clear();
    }

    private static InetSocketAddress resolveAddress(int maxResolveAddressAttempts, InetSocketAddress address) {
        int resolveAttempts = 0;
        while (address.isUnresolved() && resolveAttempts < maxResolveAddressAttempts) {
            LOG.warn((Object)("resolveAddress: Failed to resolve " + address + " on attempt " + ++resolveAttempts + " of " + maxResolveAddressAttempts + " attempts, sleeping for 5 seconds"));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"resolveAddress: Interrupted.", (Throwable)e);
            }
            address = new InetSocketAddress(address.getHostName(), address.getPort());
        }
        if (resolveAttempts >= maxResolveAddressAttempts) {
            throw new IllegalStateException("resolveAddress: Couldn't resolve " + address + " in " + resolveAttempts + " tries.");
        }
        return address;
    }

    private static class LogOnErrorChannelFutureListener
    implements ChannelFutureListener {
        private LogOnErrorChannelFutureListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isDone() && !future.isSuccess()) {
                LOG.error((Object)"Request failed", future.cause());
            }
        }
    }

    private static class ChannelFutureAddress {
        private final ChannelFuture future;
        private final InetSocketAddress address;
        private final Integer taskId;

        ChannelFutureAddress(ChannelFuture future, InetSocketAddress address, Integer taskId) {
            this.future = future;
            this.address = address;
            this.taskId = taskId;
        }

        public String toString() {
            return "(future=" + this.future + ",address=" + this.address + ",taskId=" + this.taskId + ")";
        }
    }
}

