/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.giraph.comm.netty.ByteCounter;
import org.apache.giraph.comm.netty.ByteCounterDelegate;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.log4j.Logger;

@ChannelHandler.Sharable
public class InboundByteCounter
extends ChannelInboundHandlerAdapter
implements ByteCounter,
ResetSuperstepMetricsObserver {
    private static final Logger LOG = Logger.getLogger(InboundByteCounter.class);
    private final ByteCounterDelegate delegate = new ByteCounterDelegate(true);

    public InboundByteCounter() {
        GiraphMetrics.get().addSuperstepResetObserver(this);
    }

    public long getBytesReceived() {
        return this.delegate.getBytesProcessed();
    }

    public double getMbytesPerSecReceived() {
        return this.delegate.getMbytesPerSecProcessed();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            int receivedBytes = this.delegate.byteBookkeeper(buf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("channelRead: " + ctx.channel().toString() + " buffer " + "size = " + receivedBytes + ", total bytes = " + this.getBytesReceived()));
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        this.delegate.newSuperstep(superstepMetrics);
    }

    @Override
    public void resetAll() {
        this.delegate.resetAll();
    }

    @Override
    public String getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public String getMetricsWindow(int minMsecsWindow) {
        return this.delegate.getMetricsWindow(minMsecsWindow);
    }
}

