/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.google.common.collect.Lists;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;

public class ChannelRotater {
    private int index = 0;
    private final List<Channel> channelList = Lists.newArrayList();
    private final Integer taskId;

    public ChannelRotater(Integer taskId) {
        this.taskId = taskId;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addChannel(Channel channel) {
        List<Channel> list = this.channelList;
        synchronized (list) {
            this.channelList.add(channel);
        }
    }

    public synchronized Channel nextChannel() {
        if (this.channelList.isEmpty()) {
            throw new IllegalArgumentException("nextChannel: No channels exist!");
        }
        ++this.index;
        if (this.index >= this.channelList.size()) {
            this.index = 0;
        }
        return this.channelList.get(this.index);
    }

    public synchronized boolean removeChannel(Channel channel) {
        boolean success = this.channelList.remove(channel);
        if (this.index >= this.channelList.size()) {
            this.index = 0;
        }
        return success;
    }

    public synchronized int size() {
        return this.channelList.size();
    }

    public synchronized void closeChannels(ChannelFutureListener channelFutureListener) {
        for (Channel channel : this.channelList) {
            ChannelFuture channelFuture = channel.close();
            if (channelFutureListener == null) continue;
            channelFuture.addListener((GenericFutureListener)channelFutureListener);
        }
    }

    public synchronized Iterable<Channel> getChannels() {
        return Lists.newArrayList(this.channelList);
    }
}

