/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.NoOpHistogram;
import com.yammer.metrics.core.NoOpMeter;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.giraph.comm.netty.ByteCounter;
import org.apache.giraph.metrics.MeterDesc;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;

public class ByteCounterDelegate
implements ByteCounter {
    public static final double MEGABYTE = 1048576.0;
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#######.####");
    private static final Time TIME = SystemTime.get();
    private final AtomicLong bytesProcessed = new AtomicLong();
    private final AtomicLong processedRequests = new AtomicLong();
    private final AtomicLong startMsecs = new AtomicLong();
    private final AtomicLong metricsWindowLastUpdatedMsecs = new AtomicLong();
    private Meter processedRequestsMeter = NoOpMeter.INSTANCE;
    private Histogram processedBytesHist = NoOpHistogram.INSTANCE;
    private final boolean isInbound;

    public ByteCounterDelegate(boolean isInBound) {
        this.isInbound = isInBound;
    }

    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        if (this.isInbound) {
            this.processedRequestsMeter = superstepMetrics.getMeter(MeterDesc.RECEIVED_REQUESTS);
            this.processedBytesHist = superstepMetrics.getUniformHistogram("received-bytes");
        } else {
            this.processedRequestsMeter = superstepMetrics.getMeter(MeterDesc.SENT_REQUESTS);
            this.processedBytesHist = superstepMetrics.getUniformHistogram("sent-bytes");
        }
    }

    public int byteBookkeeper(ByteBuf buf) {
        int processedBytes = buf.readableBytes();
        this.bytesProcessed.addAndGet(processedBytes);
        this.processedBytesHist.update(processedBytes);
        this.processedRequests.incrementAndGet();
        this.processedRequestsMeter.mark();
        return processedBytes;
    }

    public void resetBytes() {
        this.bytesProcessed.set(0L);
        this.processedRequests.set(0L);
    }

    public void resetStartMsecs() {
        this.startMsecs.set(TIME.getMilliseconds());
    }

    @Override
    public void resetAll() {
        this.resetBytes();
        this.resetStartMsecs();
    }

    public long getBytesProcessed() {
        return this.bytesProcessed.get();
    }

    public double getMbytesPerSecProcessed() {
        return (double)((float)this.bytesProcessed.get() * 1000.0f / (float)(1L + TIME.getMilliseconds() - this.startMsecs.get())) / 1048576.0;
    }

    public String getMetricsHelper(double mBytesProcessed, double mBytesProcessedPerReq) {
        if (this.isInbound) {
            return "MBytes/sec received = " + DOUBLE_FORMAT.format(this.getMbytesPerSecProcessed()) + ", MBytesReceived = " + DOUBLE_FORMAT.format(mBytesProcessed) + ", ave received req MBytes = " + DOUBLE_FORMAT.format(mBytesProcessedPerReq) + ", secs waited = " + (float)(TIME.getMilliseconds() - this.startMsecs.get()) / 1000.0f;
        }
        return "MBytes/sec sent = " + DOUBLE_FORMAT.format(this.getMbytesPerSecProcessed()) + ", MBytesSent = " + DOUBLE_FORMAT.format(mBytesProcessed) + ", ave sent req MBytes = " + DOUBLE_FORMAT.format(mBytesProcessedPerReq) + ", secs waited = " + (float)(TIME.getMilliseconds() - this.startMsecs.get()) / 1000.0f;
    }

    @Override
    public String getMetrics() {
        double mBytesProcessed = (double)this.bytesProcessed.get() / 1048576.0;
        long curProcessedRequests = this.processedRequests.get();
        double mBytesProcessedPerReq = curProcessedRequests == 0L ? 0.0 : mBytesProcessed / (double)curProcessedRequests;
        return this.getMetricsHelper(mBytesProcessed, mBytesProcessedPerReq);
    }

    @Override
    public String getMetricsWindow(int minMsecsWindow) {
        long lastUpdatedMsecs = this.metricsWindowLastUpdatedMsecs.get();
        long curMsecs = TIME.getMilliseconds();
        if (curMsecs - lastUpdatedMsecs > (long)minMsecsWindow && this.metricsWindowLastUpdatedMsecs.compareAndSet(lastUpdatedMsecs, curMsecs)) {
            String metrics = this.getMetrics();
            this.resetAll();
            return metrics;
        }
        return null;
    }
}

