/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.queue;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.queue.PartitionMessage;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public final class AsyncMessageStoreWrapper<I extends WritableComparable, M extends Writable>
implements MessageStore<I, M> {
    private static final Logger LOG = Logger.getLogger(AsyncMessageStoreWrapper.class);
    private static final PartitionMessage SHUTDOWN_QUEUE_MESSAGE = new PartitionMessage(-1, null);
    private static final PartitionMessage CLEAR_QUEUE_MESSAGE = new PartitionMessage(-1, null);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AsyncMessageStoreWrapper-%d").build());
    private final int threadsCount;
    private final BlockingQueue<PartitionMessage<I, M>>[] queues;
    private final Int2IntMap partition2Queue;
    private Semaphore completionSemaphore;
    private final MessageStore<I, M> store;

    public AsyncMessageStoreWrapper(MessageStore<I, M> store, Iterable<Integer> partitions, int threadCount) {
        this.store = store;
        this.threadsCount = threadCount;
        this.completionSemaphore = new Semaphore(1 - this.threadsCount);
        this.queues = new BlockingQueue[this.threadsCount];
        this.partition2Queue = new Int2IntArrayMap();
        LOG.info((Object)("AsyncMessageStoreWrapper enabled. Threads= " + this.threadsCount));
        for (int i = 0; i < this.threadsCount; ++i) {
            this.queues[i] = new LinkedBlockingQueue<PartitionMessage<I, M>>();
            EXECUTOR_SERVICE.submit(new MessageStoreQueueWorker(this.queues[i]));
        }
        int cnt = 0;
        for (int partitionId : partitions) {
            this.partition2Queue.put(partitionId, cnt++ % this.threadsCount);
        }
    }

    @Override
    public boolean isPointerListEncoding() {
        return this.store.isPointerListEncoding();
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        return this.store.getVertexMessages(vertexId);
    }

    @Override
    public void clearVertexMessages(I vertexId) throws IOException {
        this.store.clearVertexMessages(vertexId);
    }

    @Override
    public void clearAll() throws IOException {
        try {
            for (BlockingQueue<PartitionMessage<I, M>> queue : this.queues) {
                queue.put(SHUTDOWN_QUEUE_MESSAGE);
            }
            this.completionSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.store.clearAll();
    }

    @Override
    public boolean hasMessagesForVertex(I vertexId) {
        return this.store.hasMessagesForVertex(vertexId);
    }

    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        int hash = this.partition2Queue.get(partitionId);
        try {
            this.queues[hash].put(new PartitionMessage<I, M>(partitionId, messages));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void finalizeStore() {
        this.store.finalizeStore();
    }

    @Override
    public Iterable<I> getPartitionDestinationVertices(int partitionId) {
        return this.store.getPartitionDestinationVertices(partitionId);
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        this.store.clearPartition(partitionId);
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        this.store.writePartition(out, partitionId);
    }

    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        this.store.readFieldsForPartition(in, partitionId);
    }

    public void waitToComplete() {
        try {
            for (BlockingQueue<PartitionMessage<I, M>> queue : this.queues) {
                queue.put(CLEAR_QUEUE_MESSAGE);
            }
            this.completionSemaphore.acquire();
            this.completionSemaphore = new Semaphore(1 - this.threadsCount);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private class MessageStoreQueueWorker
    implements Runnable {
        private final BlockingQueue<PartitionMessage<I, M>> queue;

        private MessageStoreQueueWorker(BlockingQueue<PartitionMessage<I, M>> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            PartitionMessage message = null;
            try {
                while (true) {
                    if ((message = this.queue.take()).getMessage() != null) {
                        int partitionId = message.getPartitionId();
                        AsyncMessageStoreWrapper.this.store.addPartitionMessages(partitionId, message.getMessage());
                        continue;
                    }
                    AsyncMessageStoreWrapper.this.completionSemaphore.release();
                    if (message == SHUTDOWN_QUEUE_MESSAGE) break;
                }
                return;
            }
            catch (IOException | InterruptedException e) {
                LOG.error((Object)("MessageStoreQueueWorker.run: " + message), (Throwable)e);
                return;
            }
        }
    }
}

