/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives.long_id;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.PointerListMessagesIterable;
import org.apache.giraph.comm.messages.primitives.long_id.LongAbstractListMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.ExtendedByteArrayOutputBuffer;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class LongPointerListMessageStore<M extends Writable>
extends LongAbstractListMessageStore<M, LongArrayList>
implements MessageStore<LongWritable, M> {
    private final ExtendedByteArrayOutputBuffer bytesBuffer;

    public LongPointerListMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<LongWritable, Writable, Writable> service, ImmutableClassesGiraphConfiguration<LongWritable, Writable, Writable> config) {
        super(messageValueFactory, service, config);
        this.bytesBuffer = new ExtendedByteArrayOutputBuffer(config);
    }

    @Override
    public boolean isPointerListEncoding() {
        return true;
    }

    @Override
    protected LongArrayList createList() {
        return new LongArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<LongWritable, M> messages) throws IOException {
        VertexIdMessageIterator<LongWritable, M> iterator = messages.getVertexIdMessageIterator();
        long pointer = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            M msg = iterator.getCurrentMessage();
            LongArrayList list = (LongArrayList)this.getList(iterator);
            if (iterator.isNewMessage()) {
                ExtendedByteArrayOutputBuffer.IndexAndDataOut indexAndDataOut = this.bytesBuffer.getIndexAndDataOut();
                pointer = indexAndDataOut.getIndex();
                pointer <<= 32;
                ExtendedDataOutput dataOutput = indexAndDataOut.getDataOutput();
                pointer += (long)dataOutput.getPos();
                msg.write((DataOutput)dataOutput);
            }
            LongArrayList longArrayList = list;
            synchronized (longArrayList) {
                list.add(pointer);
            }
        }
    }

    @Override
    public Iterable<M> getVertexMessages(LongWritable vertexId) throws IOException {
        LongArrayList list = (LongArrayList)this.getPartitionMap(vertexId).get(vertexId.get());
        if (list == null) {
            return EmptyIterable.get();
        }
        return new PointerListMessagesIterable(this.messageValueFactory, list, this.bytesBuffer);
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
    }

    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
    }
}

