/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives.long_id;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.comm.messages.primitives.long_id.LongAbstractMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VerboseByteStructMessageWrite;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class LongByteArrayMessageStore<M extends Writable>
extends LongAbstractMessageStore<M, DataInputOutput> {
    public LongByteArrayMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<LongWritable, Writable, Writable> service, ImmutableClassesGiraphConfiguration<LongWritable, Writable, Writable> config) {
        super(messageValueFactory, service, config);
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    private DataInputOutput getDataInputOutput(Long2ObjectOpenHashMap<DataInputOutput> partitionMap, long vertexId) {
        DataInputOutput dataInputOutput = (DataInputOutput)partitionMap.get(vertexId);
        if (dataInputOutput == null) {
            dataInputOutput = this.config.createMessagesInputOutput();
            partitionMap.put(vertexId, (Object)dataInputOutput);
        }
        return dataInputOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<LongWritable, M> messages) throws IOException {
        Long2ObjectOpenHashMap partitionMap;
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = partitionMap = (Long2ObjectOpenHashMap)this.map.get(partitionId);
        synchronized (long2ObjectOpenHashMap) {
            VertexIdMessageBytesIterator<LongWritable, M> vertexIdMessageBytesIterator = messages.getVertexIdMessageBytesIterator();
            if (vertexIdMessageBytesIterator != null) {
                while (vertexIdMessageBytesIterator.hasNext()) {
                    vertexIdMessageBytesIterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput((Long2ObjectOpenHashMap<DataInputOutput>)partitionMap, ((LongWritable)vertexIdMessageBytesIterator.getCurrentVertexId()).get());
                    vertexIdMessageBytesIterator.writeCurrentMessageBytes(dataInputOutput.getDataOutput());
                }
            } else {
                VertexIdMessageIterator<LongWritable, M> iterator = messages.getVertexIdMessageIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput((Long2ObjectOpenHashMap<DataInputOutput>)partitionMap, ((LongWritable)iterator.getCurrentVertexId()).get());
                    VerboseByteStructMessageWrite.verboseWriteCurrentMessage(iterator, dataInputOutput.getDataOutput());
                }
            }
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public Iterable<M> getVertexMessages(LongWritable vertexId) throws IOException {
        DataInputOutput dataInputOutput = (DataInputOutput)this.getPartitionMap(vertexId).get(vertexId.get());
        if (dataInputOutput == null) {
            return EmptyIterable.get();
        }
        return new MessagesIterable(dataInputOutput, this.messageValueFactory);
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Long2ObjectOpenHashMap partitionMap = (Long2ObjectOpenHashMap)this.map.get(partitionId);
        out.writeInt(partitionMap.size());
        ObjectIterator iterator = partitionMap.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            out.writeLong(entry.getLongKey());
            ((DataInputOutput)entry.getValue()).write(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        int size = in.readInt();
        Long2ObjectOpenHashMap partitionMap = new Long2ObjectOpenHashMap(size);
        while (size-- > 0) {
            long vertexId = in.readLong();
            DataInputOutput dataInputOutput = this.config.createMessagesInputOutput();
            dataInputOutput.readFields(in);
            partitionMap.put(vertexId, (Object)dataInputOutput);
        }
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, (Object)partitionMap);
        }
    }
}

