/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives.long_id;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.partition.Partition;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public abstract class LongAbstractMessageStore<M extends Writable, T>
implements MessageStore<LongWritable, M> {
    protected final MessageValueFactory<M> messageValueFactory;
    protected final Int2ObjectOpenHashMap<Long2ObjectOpenHashMap<T>> map;
    protected final CentralizedServiceWorker<LongWritable, ?, ?> service;
    protected final ImmutableClassesGiraphConfiguration<LongWritable, ?, ?> config;

    public LongAbstractMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<LongWritable, Writable, Writable> service, ImmutableClassesGiraphConfiguration<LongWritable, Writable, Writable> config) {
        this.messageValueFactory = messageValueFactory;
        this.service = service;
        this.config = config;
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            Partition<LongWritable, Writable, Writable> partition = service.getPartitionStore().getOrCreatePartition(partitionId);
            Long2ObjectOpenHashMap partitionMap = new Long2ObjectOpenHashMap((int)partition.getVertexCount());
            this.map.put(partitionId, (Object)partitionMap);
            service.getPartitionStore().putPartition(partition);
        }
    }

    protected Long2ObjectOpenHashMap<T> getPartitionMap(LongWritable vertexId) {
        return (Long2ObjectOpenHashMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Long2ObjectOpenHashMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(LongWritable vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId.get());
    }

    @Override
    public void clearVertexMessages(LongWritable vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId.get());
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<LongWritable> getPartitionDestinationVertices(int partitionId) {
        Long2ObjectOpenHashMap partitionMap = (Long2ObjectOpenHashMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        LongIterator iterator = partitionMap.keySet().iterator();
        while (iterator.hasNext()) {
            vertices.add(new LongWritable(iterator.nextLong()));
        }
        return vertices;
    }
}

