/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives.long_id;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.primitives.long_id.LongAbstractMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.VertexIdIterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public abstract class LongAbstractListMessageStore<M extends Writable, L extends List>
extends LongAbstractMessageStore<M, L> {
    private final Int2ObjectOpenHashMap<Long2ObjectOpenHashMap<L>> nascentMap;

    public LongAbstractListMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<LongWritable, Writable, Writable> service, ImmutableClassesGiraphConfiguration<LongWritable, Writable, Writable> config) {
        super(messageValueFactory, service, config);
        this.populateMap();
        this.nascentMap = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            this.nascentMap.put(partitionId, (Object)new Long2ObjectOpenHashMap());
        }
    }

    private void populateMap() {
        for (int partitionId : this.service.getPartitionStore().getPartitionIds()) {
            Partition partition = this.service.getPartitionStore().getOrCreatePartition(partitionId);
            Long2ObjectOpenHashMap partitionMap = (Long2ObjectOpenHashMap)this.map.get(partitionId);
            for (Vertex vertex : partition) {
                partitionMap.put(((LongWritable)vertex.getId()).get(), this.createList());
            }
        }
    }

    protected abstract L createList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected L getList(VertexIdIterator<LongWritable> iterator) {
        PartitionOwner owner = this.service.getVertexPartitionOwner(iterator.getCurrentVertexId());
        long vertexId = iterator.getCurrentVertexId().get();
        int partitionId = owner.getPartitionId();
        Long2ObjectOpenHashMap partitionMap = (Long2ObjectOpenHashMap)this.map.get(partitionId);
        if (!partitionMap.containsKey(vertexId)) {
            Int2ObjectOpenHashMap<Long2ObjectOpenHashMap<L>> int2ObjectOpenHashMap = this.nascentMap;
            synchronized (int2ObjectOpenHashMap) {
                Long2ObjectOpenHashMap nascentPartitionMap = (Long2ObjectOpenHashMap)this.nascentMap.get(partitionId);
                if (nascentPartitionMap.get(vertexId) == null) {
                    nascentPartitionMap.put(vertexId, this.createList());
                }
                return (L)((List)nascentPartitionMap.get(vertexId));
            }
        }
        return (L)((List)partitionMap.get(vertexId));
    }

    @Override
    public void finalizeStore() {
        Iterator i$ = this.nascentMap.keySet().iterator();
        while (i$.hasNext()) {
            int partitionId = (Integer)i$.next();
            ((Long2ObjectOpenHashMap)this.map.get(partitionId)).putAll((Map)this.nascentMap.get(partitionId));
        }
        this.nascentMap.clear();
    }
}

