/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class LongDoubleMessageStore
implements MessageStore<LongWritable, DoubleWritable> {
    private final Int2ObjectOpenHashMap<Long2DoubleOpenHashMap> map;
    private final MessageCombiner<? super LongWritable, DoubleWritable> messageCombiner;
    private final CentralizedServiceWorker<LongWritable, ?, ?> service;

    public LongDoubleMessageStore(CentralizedServiceWorker<LongWritable, Writable, Writable> service, MessageCombiner<? super LongWritable, DoubleWritable> messageCombiner) {
        this.service = service;
        this.messageCombiner = messageCombiner;
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            Partition<LongWritable, Writable, Writable> partition = service.getPartitionStore().getOrCreatePartition(partitionId);
            Long2DoubleOpenHashMap partitionMap = new Long2DoubleOpenHashMap((int)partition.getVertexCount());
            this.map.put(partitionId, (Object)partitionMap);
            service.getPartitionStore().putPartition(partition);
        }
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    private Long2DoubleOpenHashMap getPartitionMap(LongWritable vertexId) {
        return (Long2DoubleOpenHashMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<LongWritable, DoubleWritable> messages) throws IOException {
        Long2DoubleOpenHashMap partitionMap;
        LongWritable reusableVertexId = new LongWritable();
        DoubleWritable reusableMessage = new DoubleWritable();
        DoubleWritable reusableCurrentMessage = new DoubleWritable();
        Long2DoubleOpenHashMap long2DoubleOpenHashMap = partitionMap = (Long2DoubleOpenHashMap)this.map.get(partitionId);
        synchronized (long2DoubleOpenHashMap) {
            VertexIdMessageIterator<LongWritable, DoubleWritable> iterator = messages.getVertexIdMessageIterator();
            while (iterator.hasNext()) {
                iterator.next();
                long vertexId = ((LongWritable)iterator.getCurrentVertexId()).get();
                double message = iterator.getCurrentMessage().get();
                if (partitionMap.containsKey(vertexId)) {
                    reusableVertexId.set(vertexId);
                    reusableMessage.set(message);
                    reusableCurrentMessage.set(partitionMap.get(vertexId));
                    this.messageCombiner.combine((LongWritable)reusableVertexId, reusableCurrentMessage, reusableMessage);
                    message = reusableCurrentMessage.get();
                }
                partitionMap.put(vertexId, message);
            }
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Long2DoubleOpenHashMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(LongWritable vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId.get());
    }

    @Override
    public Iterable<DoubleWritable> getVertexMessages(LongWritable vertexId) throws IOException {
        Long2DoubleOpenHashMap partitionMap = this.getPartitionMap(vertexId);
        if (!partitionMap.containsKey(vertexId.get())) {
            return EmptyIterable.get();
        }
        return Collections.singleton(new DoubleWritable(partitionMap.get(vertexId.get())));
    }

    @Override
    public void clearVertexMessages(LongWritable vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId.get());
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<LongWritable> getPartitionDestinationVertices(int partitionId) {
        Long2DoubleOpenHashMap partitionMap = (Long2DoubleOpenHashMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        LongIterator iterator = partitionMap.keySet().iterator();
        while (iterator.hasNext()) {
            vertices.add(new LongWritable(iterator.nextLong()));
        }
        return vertices;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Long2DoubleOpenHashMap partitionMap = (Long2DoubleOpenHashMap)this.map.get(partitionId);
        out.writeInt(partitionMap.size());
        ObjectIterator iterator = partitionMap.long2DoubleEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2DoubleMap.Entry entry = (Long2DoubleMap.Entry)iterator.next();
            out.writeLong(entry.getLongKey());
            out.writeDouble(entry.getDoubleValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        int size = in.readInt();
        Long2DoubleOpenHashMap partitionMap = new Long2DoubleOpenHashMap(size);
        while (size-- > 0) {
            long vertexId = in.readLong();
            double message = in.readDouble();
            partitionMap.put(vertexId, message);
        }
        Int2ObjectOpenHashMap<Long2DoubleOpenHashMap> int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, (Object)partitionMap);
        }
    }
}

