/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class IntFloatMessageStore
implements MessageStore<IntWritable, FloatWritable> {
    private final Int2ObjectOpenHashMap<Int2FloatOpenHashMap> map;
    private final MessageCombiner<? super IntWritable, FloatWritable> messageCombiner;
    private final CentralizedServiceWorker<IntWritable, ?, ?> service;

    public IntFloatMessageStore(CentralizedServiceWorker<IntWritable, Writable, Writable> service, MessageCombiner<? super IntWritable, FloatWritable> messageCombiner) {
        this.service = service;
        this.messageCombiner = messageCombiner;
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            PartitionStore<IntWritable, Writable, Writable> partitionStore = service.getPartitionStore();
            Partition<IntWritable, Writable, Writable> partition = partitionStore.getOrCreatePartition(partitionId);
            Int2FloatOpenHashMap partitionMap = new Int2FloatOpenHashMap((int)partition.getVertexCount());
            this.map.put(partitionId, (Object)partitionMap);
            partitionStore.putPartition(partition);
        }
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    private Int2FloatOpenHashMap getPartitionMap(IntWritable vertexId) {
        return (Int2FloatOpenHashMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<IntWritable, FloatWritable> messages) throws IOException {
        Int2FloatOpenHashMap partitionMap;
        IntWritable reusableVertexId = new IntWritable();
        FloatWritable reusableMessage = new FloatWritable();
        FloatWritable reusableCurrentMessage = new FloatWritable();
        Int2FloatOpenHashMap int2FloatOpenHashMap = partitionMap = (Int2FloatOpenHashMap)this.map.get(partitionId);
        synchronized (int2FloatOpenHashMap) {
            VertexIdMessageIterator<IntWritable, FloatWritable> iterator = messages.getVertexIdMessageIterator();
            while (iterator.hasNext()) {
                iterator.next();
                int vertexId = ((IntWritable)iterator.getCurrentVertexId()).get();
                float message = iterator.getCurrentMessage().get();
                if (partitionMap.containsKey(vertexId)) {
                    reusableVertexId.set(vertexId);
                    reusableMessage.set(message);
                    reusableCurrentMessage.set(partitionMap.get(vertexId));
                    this.messageCombiner.combine((IntWritable)reusableVertexId, reusableCurrentMessage, reusableMessage);
                    message = reusableCurrentMessage.get();
                }
                partitionMap.put(vertexId, message);
            }
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Int2FloatOpenHashMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(IntWritable vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId.get());
    }

    @Override
    public Iterable<FloatWritable> getVertexMessages(IntWritable vertexId) throws IOException {
        Int2FloatOpenHashMap partitionMap = this.getPartitionMap(vertexId);
        if (!partitionMap.containsKey(vertexId.get())) {
            return EmptyIterable.get();
        }
        return Collections.singleton(new FloatWritable(partitionMap.get(vertexId.get())));
    }

    @Override
    public void clearVertexMessages(IntWritable vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId.get());
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<IntWritable> getPartitionDestinationVertices(int partitionId) {
        Int2FloatOpenHashMap partitionMap = (Int2FloatOpenHashMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        IntIterator iterator = partitionMap.keySet().iterator();
        while (iterator.hasNext()) {
            vertices.add(new IntWritable(iterator.nextInt()));
        }
        return vertices;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Int2FloatOpenHashMap partitionMap = (Int2FloatOpenHashMap)this.map.get(partitionId);
        out.writeInt(partitionMap.size());
        ObjectIterator iterator = partitionMap.int2FloatEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2FloatMap.Entry entry = (Int2FloatMap.Entry)iterator.next();
            out.writeInt(entry.getIntKey());
            out.writeFloat(entry.getFloatValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        int size = in.readInt();
        Int2FloatOpenHashMap partitionMap = new Int2FloatOpenHashMap(size);
        while (size-- > 0) {
            int vertexId = in.readInt();
            float message = in.readFloat();
            partitionMap.put(vertexId, message);
        }
        Int2ObjectOpenHashMap<Int2FloatOpenHashMap> int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, (Object)partitionMap);
        }
    }
}

