/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VerboseByteStructMessageWrite;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class IntByteArrayMessageStore<M extends Writable>
implements MessageStore<IntWritable, M> {
    protected final MessageValueFactory<M> messageValueFactory;
    private final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<DataInputOutput>> map;
    private final CentralizedServiceWorker<IntWritable, ?, ?> service;
    private final ImmutableClassesGiraphConfiguration<IntWritable, ?, ?> config;

    public IntByteArrayMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<IntWritable, Writable, Writable> service, ImmutableClassesGiraphConfiguration<IntWritable, Writable, Writable> config) {
        this.messageValueFactory = messageValueFactory;
        this.service = service;
        this.config = config;
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            Partition<IntWritable, Writable, Writable> partition = service.getPartitionStore().getOrCreatePartition(partitionId);
            Int2ObjectOpenHashMap partitionMap = new Int2ObjectOpenHashMap((int)partition.getVertexCount());
            this.map.put(partitionId, (Object)partitionMap);
            service.getPartitionStore().putPartition(partition);
        }
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    private Int2ObjectOpenHashMap<DataInputOutput> getPartitionMap(IntWritable vertexId) {
        return (Int2ObjectOpenHashMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    private DataInputOutput getDataInputOutput(Int2ObjectOpenHashMap<DataInputOutput> partitionMap, int vertexId) {
        DataInputOutput dataInputOutput = (DataInputOutput)partitionMap.get(vertexId);
        if (dataInputOutput == null) {
            dataInputOutput = this.config.createMessagesInputOutput();
            partitionMap.put(vertexId, (Object)dataInputOutput);
        }
        return dataInputOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<IntWritable, M> messages) throws IOException {
        Int2ObjectOpenHashMap partitionMap;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap = partitionMap = (Int2ObjectOpenHashMap)this.map.get(partitionId);
        synchronized (int2ObjectOpenHashMap) {
            VertexIdMessageBytesIterator<IntWritable, M> vertexIdMessageBytesIterator = messages.getVertexIdMessageBytesIterator();
            if (vertexIdMessageBytesIterator != null) {
                while (vertexIdMessageBytesIterator.hasNext()) {
                    vertexIdMessageBytesIterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput((Int2ObjectOpenHashMap<DataInputOutput>)partitionMap, ((IntWritable)vertexIdMessageBytesIterator.getCurrentVertexId()).get());
                    vertexIdMessageBytesIterator.writeCurrentMessageBytes(dataInputOutput.getDataOutput());
                }
            } else {
                VertexIdMessageIterator<IntWritable, M> iterator = messages.getVertexIdMessageIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput((Int2ObjectOpenHashMap<DataInputOutput>)partitionMap, ((IntWritable)iterator.getCurrentVertexId()).get());
                    VerboseByteStructMessageWrite.verboseWriteCurrentMessage(iterator, dataInputOutput.getDataOutput());
                }
            }
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Int2ObjectOpenHashMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(IntWritable vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId.get());
    }

    @Override
    public Iterable<M> getVertexMessages(IntWritable vertexId) throws IOException {
        DataInputOutput dataInputOutput = (DataInputOutput)this.getPartitionMap(vertexId).get(vertexId.get());
        if (dataInputOutput == null) {
            return EmptyIterable.get();
        }
        return new MessagesIterable<M>(dataInputOutput, this.messageValueFactory);
    }

    @Override
    public void clearVertexMessages(IntWritable vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId.get());
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<IntWritable> getPartitionDestinationVertices(int partitionId) {
        Int2ObjectOpenHashMap partitionMap = (Int2ObjectOpenHashMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        IntIterator iterator = partitionMap.keySet().iterator();
        while (iterator.hasNext()) {
            vertices.add(new IntWritable(iterator.nextInt()));
        }
        return vertices;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Int2ObjectOpenHashMap partitionMap = (Int2ObjectOpenHashMap)this.map.get(partitionId);
        out.writeInt(partitionMap.size());
        ObjectIterator iterator = partitionMap.int2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            out.writeInt(entry.getIntKey());
            ((DataInputOutput)entry.getValue()).write(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        int size = in.readInt();
        Int2ObjectOpenHashMap partitionMap = new Int2ObjectOpenHashMap(size);
        while (size-- > 0) {
            int vertexId = in.readInt();
            DataInputOutput dataInputOutput = this.config.createMessagesInputOutput();
            dataInputOutput.readFields(in);
            partitionMap.put(vertexId, (Object)dataInputOutput);
        }
        Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<DataInputOutput>> int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, (Object)partitionMap);
        }
    }
}

