/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.TypeOpsUtils;
import org.apache.giraph.types.ops.collections.Basic2ObjectMap;
import org.apache.giraph.types.ops.collections.WritableWriter;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class IdOneMessagePerVertexStore<I extends WritableComparable, M extends Writable>
implements MessageStore<I, M> {
    private final Int2ObjectOpenHashMap<Basic2ObjectMap<I, M>> map;
    private final MessageValueFactory<M> messageValueFactory;
    private final MessageCombiner<I, M> messageCombiner;
    private final CentralizedServiceWorker<I, ?, ?> service;
    private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
    private final PrimitiveIdTypeOps<I> idTypeOps;
    private final WritableWriter<M> messageWriter = new WritableWriter<M>(){

        @Override
        public M readFields(DataInput in) throws IOException {
            Object message = IdOneMessagePerVertexStore.this.messageValueFactory.newInstance();
            message.readFields(in);
            return message;
        }

        @Override
        public void write(DataOutput out, M value) throws IOException {
            value.write(out);
        }
    };

    public IdOneMessagePerVertexStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, MessageCombiner<I, M> messageCombiner, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        this.service = service;
        this.config = config;
        this.messageValueFactory = messageValueFactory;
        this.messageCombiner = messageCombiner;
        this.idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOps(config.getVertexIdClass());
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            Partition<I, ?, ?> partition = service.getPartitionStore().getOrCreatePartition(partitionId);
            Basic2ObjectMap partitionMap = this.idTypeOps.create2ObjectOpenHashMap((int)partition.getVertexCount());
            this.map.put(partitionId, partitionMap);
            service.getPartitionStore().putPartition(partition);
        }
    }

    private Basic2ObjectMap<I, M> getPartitionMap(I vertexId) {
        return (Basic2ObjectMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        Basic2ObjectMap partitionMap;
        Basic2ObjectMap basic2ObjectMap = partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        synchronized (basic2ObjectMap) {
            VertexIdMessageIterator<I, M> iterator = messages.getVertexIdMessageIterator();
            while (iterator.hasNext()) {
                iterator.next();
                Object vertexId = iterator.getCurrentVertexId();
                Object currentMessage = (Writable)partitionMap.get(iterator.getCurrentVertexId());
                if (currentMessage == null) {
                    M newMessage = this.messageCombiner.createInitialMessage();
                    currentMessage = (Writable)partitionMap.put(iterator.getCurrentVertexId(), newMessage);
                    if (currentMessage == null) {
                        currentMessage = newMessage;
                    }
                }
                this.messageCombiner.combine(vertexId, (Writable)currentMessage, (Writable)iterator.getCurrentMessage());
            }
        }
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Basic2ObjectMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(I vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId);
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        Basic2ObjectMap<I, M> partitionMap = this.getPartitionMap(vertexId);
        if (!partitionMap.containsKey(vertexId)) {
            return EmptyIterable.get();
        }
        return Collections.singleton(partitionMap.get(vertexId));
    }

    @Override
    public void clearVertexMessages(I vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId);
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<I> getPartitionDestinationVertices(int partitionId) {
        Basic2ObjectMap partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        Iterator iterator = partitionMap.fastKeyIterator();
        while (iterator.hasNext()) {
            vertices.add(this.idTypeOps.createCopy(iterator.next()));
        }
        return vertices;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Basic2ObjectMap partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        partitionMap.write(out, this.messageWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        Basic2ObjectMap<I, M> partitionMap = this.idTypeOps.create2ObjectOpenHashMap(10);
        partitionMap.readFields(in, this.messageWriter);
        Int2ObjectOpenHashMap<Basic2ObjectMap<I, M>> int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, partitionMap);
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }
}

