/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.primitives;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.TypeOpsUtils;
import org.apache.giraph.types.ops.collections.Basic2ObjectMap;
import org.apache.giraph.types.ops.collections.WritableWriter;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VerboseByteStructMessageWrite;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class IdByteArrayMessageStore<I extends WritableComparable, M extends Writable>
implements MessageStore<I, M> {
    protected final MessageValueFactory<M> messageValueFactory;
    private final Int2ObjectOpenHashMap<Basic2ObjectMap<I, DataInputOutput>> map;
    private final CentralizedServiceWorker<I, ?, ?> service;
    private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
    private final PrimitiveIdTypeOps<I> idTypeOps;
    private final WritableWriter<DataInputOutput> dataInputOutputWriter = new WritableWriter<DataInputOutput>(){

        @Override
        public DataInputOutput readFields(DataInput in) throws IOException {
            DataInputOutput dataInputOutput = IdByteArrayMessageStore.this.config.createMessagesInputOutput();
            dataInputOutput.readFields(in);
            return dataInputOutput;
        }

        @Override
        public void write(DataOutput out, DataInputOutput value) throws IOException {
            value.write(out);
        }
    };

    public IdByteArrayMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        this.messageValueFactory = messageValueFactory;
        this.service = service;
        this.config = config;
        this.idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOps(config.getVertexIdClass());
        this.map = new Int2ObjectOpenHashMap();
        for (int partitionId : service.getPartitionStore().getPartitionIds()) {
            Partition<I, ?, ?> partition = service.getPartitionStore().getOrCreatePartition(partitionId);
            Basic2ObjectMap partitionMap = this.idTypeOps.create2ObjectOpenHashMap(Math.max(10, (int)partition.getVertexCount()));
            this.map.put(partitionId, partitionMap);
            service.getPartitionStore().putPartition(partition);
        }
    }

    private Basic2ObjectMap<I, DataInputOutput> getPartitionMap(I vertexId) {
        return (Basic2ObjectMap)this.map.get(this.service.getPartitionId(vertexId));
    }

    private DataInputOutput getDataInputOutput(Basic2ObjectMap<I, DataInputOutput> partitionMap, I vertexId) {
        DataInputOutput dataInputOutput = partitionMap.get(vertexId);
        if (dataInputOutput == null) {
            dataInputOutput = this.config.createMessagesInputOutput();
            partitionMap.put(vertexId, dataInputOutput);
        }
        return dataInputOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        Basic2ObjectMap partitionMap;
        Basic2ObjectMap basic2ObjectMap = partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        synchronized (basic2ObjectMap) {
            VertexIdMessageBytesIterator<I, M> vertexIdMessageBytesIterator = messages.getVertexIdMessageBytesIterator();
            if (vertexIdMessageBytesIterator != null) {
                while (vertexIdMessageBytesIterator.hasNext()) {
                    vertexIdMessageBytesIterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput(partitionMap, vertexIdMessageBytesIterator.getCurrentVertexId());
                    vertexIdMessageBytesIterator.writeCurrentMessageBytes(dataInputOutput.getDataOutput());
                }
            } else {
                VertexIdMessageIterator<I, M> iterator = messages.getVertexIdMessageIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    DataInputOutput dataInputOutput = this.getDataInputOutput(partitionMap, iterator.getCurrentVertexId());
                    VerboseByteStructMessageWrite.verboseWriteCurrentMessage(iterator, dataInputOutput.getDataOutput());
                }
            }
        }
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        ((Basic2ObjectMap)this.map.get(partitionId)).clear();
    }

    @Override
    public boolean hasMessagesForVertex(I vertexId) {
        return this.getPartitionMap(vertexId).containsKey(vertexId);
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        DataInputOutput dataInputOutput = this.getPartitionMap(vertexId).get(vertexId);
        if (dataInputOutput == null) {
            return EmptyIterable.get();
        }
        return new MessagesIterable<M>(dataInputOutput, this.messageValueFactory);
    }

    @Override
    public void clearVertexMessages(I vertexId) throws IOException {
        this.getPartitionMap(vertexId).remove(vertexId);
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }

    @Override
    public Iterable<I> getPartitionDestinationVertices(int partitionId) {
        Basic2ObjectMap partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        ArrayList vertices = Lists.newArrayListWithCapacity((int)partitionMap.size());
        Iterator iterator = partitionMap.fastKeyIterator();
        while (iterator.hasNext()) {
            vertices.add(this.idTypeOps.createCopy(iterator.next()));
        }
        return vertices;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        Basic2ObjectMap partitionMap = (Basic2ObjectMap)this.map.get(partitionId);
        partitionMap.write(out, this.dataInputOutputWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        Basic2ObjectMap<I, DataInputOutput> partitionMap = this.idTypeOps.create2ObjectOpenHashMap(10);
        partitionMap.readFields(in, this.dataInputOutputWriter);
        Int2ObjectOpenHashMap<Basic2ObjectMap<I, DataInputOutput>> int2ObjectOpenHashMap = this.map;
        synchronized (int2ObjectOpenHashMap) {
            this.map.put(partitionId, partitionMap);
        }
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }
}

