/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.out_of_core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SequentialFileMessageStore<I extends WritableComparable, M extends Writable>
implements Writable {
    private static final Logger LOG = Logger.getLogger(SequentialFileMessageStore.class);
    private final MessageValueFactory<M> messageValueFactory;
    private final File file;
    private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
    private final int bufferSize;
    private DataInputStream in;
    private int verticesLeft;
    private I currentVertexId;

    public SequentialFileMessageStore(MessageValueFactory<M> messageValueFactory, ImmutableClassesGiraphConfiguration<I, ?, ?> config, int bufferSize, String fileName) {
        this.messageValueFactory = messageValueFactory;
        this.config = config;
        this.bufferSize = bufferSize;
        this.file = new File(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessages(NavigableMap<I, DataInputOutput> messageMap) throws IOException {
        if (this.file.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("addMessages: Deleting " + this.file));
            }
            if (!this.file.delete()) {
                throw new IOException("Failed to delete existing file " + this.file);
            }
        }
        if (!this.file.createNewFile()) {
            throw new IOException("Failed to create file " + this.file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMessages: Creating " + this.file));
        }
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file), this.bufferSize));
            int destinationVertexIdCount = messageMap.size();
            ((DataOutputStream)out).writeInt(destinationVertexIdCount);
            for (Map.Entry entry : messageMap.entrySet()) {
                WritableComparable destinationVertexId = (WritableComparable)entry.getKey();
                destinationVertexId.write((DataOutput)((Object)out));
                DataInputOutput dataInputOutput = (DataInputOutput)entry.getValue();
                MessagesIterable<M> messages = new MessagesIterable<M>(dataInputOutput, this.messageValueFactory);
                int messageCount = Iterables.size(messages);
                ((DataOutputStream)out).writeInt(messageCount);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("addMessages: For vertex id " + destinationVertexId + ", messages = " + messageCount + " to file " + this.file));
                }
                for (Writable message : messages) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("addMessages: Wrote " + message + " to " + this.file));
                    }
                    message.write((DataOutput)((Object)out));
                }
            }
        }
    }

    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getVertexMessages: Reading for vertex id " + vertexId + " (currently " + this.currentVertexId + ") from " + this.file));
        }
        if (this.in == null) {
            this.startReading();
        }
        I nextVertexId = this.getCurrentVertexId();
        while (nextVertexId != null && vertexId.compareTo(nextVertexId) > 0) {
            nextVertexId = this.getNextVertexId();
        }
        if (nextVertexId == null || vertexId.compareTo(nextVertexId) < 0) {
            return EmptyIterable.get();
        }
        return this.readMessagesForCurrentVertex();
    }

    public void clearAll() throws IOException {
        this.endReading();
        if (!this.file.delete()) {
            LOG.error((Object)("clearAll: Failed to delete file " + this.file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.file.length());
        try (FileInputStream input = new FileInputStream(this.file);){
            int length;
            byte[] buffer = new byte[this.bufferSize];
            while ((length = input.read(buffer)) >= 0) {
                out.write(buffer, 0, length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFields(DataInput in) throws IOException {
        try (FileOutputStream output = new FileOutputStream(this.file);){
            long fileLength = in.readLong();
            byte[] buffer = new byte[this.bufferSize];
            for (long position = 0L; position < fileLength; position += (long)this.bufferSize) {
                int bytes = (int)Math.min((long)this.bufferSize, fileLength - position);
                in.readFully(buffer, 0, bytes);
                output.write(buffer);
            }
        }
    }

    private void startReading() throws IOException {
        this.currentVertexId = null;
        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file), this.bufferSize));
        this.verticesLeft = this.in.readInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startReading: File " + this.file + " with " + this.verticesLeft + " vertices left"));
        }
    }

    private I getCurrentVertexId() throws IOException {
        if (this.currentVertexId != null) {
            return this.currentVertexId;
        }
        return this.getNextVertexId();
    }

    private I getNextVertexId() throws IOException {
        if (this.currentVertexId != null) {
            this.readMessagesForCurrentVertex();
        }
        if (this.verticesLeft == 0) {
            return null;
        }
        this.currentVertexId = this.config.createVertexId();
        this.currentVertexId.readFields((DataInput)this.in);
        return this.currentVertexId;
    }

    private Collection<M> readMessagesForCurrentVertex() throws IOException {
        int messagesSize = this.in.readInt();
        ArrayList messages = Lists.newArrayListWithCapacity((int)messagesSize);
        for (int i = 0; i < messagesSize; ++i) {
            Object message = this.messageValueFactory.newInstance();
            try {
                message.readFields((DataInput)this.in);
            }
            catch (IOException e) {
                throw new IllegalStateException("readMessagesForCurrentVertex: Failed to read message from " + i + " of " + messagesSize + " for vertex id " + this.currentVertexId + " from " + this.file, e);
            }
            messages.add(message);
        }
        this.currentVertexDone();
        return messages;
    }

    private void currentVertexDone() throws IOException {
        this.currentVertexId = null;
        --this.verticesLeft;
        if (this.verticesLeft == 0) {
            this.endReading();
        }
    }

    private void endReading() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("endReading: Stopped reading " + this.file));
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public static <I extends WritableComparable, M extends Writable> MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> newFactory(ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        return new Factory(config);
    }

    private static class Factory<I extends WritableComparable, M extends Writable>
    implements MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> {
        private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
        private final String[] directories;
        private final int bufferSize;
        private final AtomicInteger storeCounter;

        public Factory(ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
            this.config = config;
            String jobId = config.get("mapred.job.id", "Unknown Job");
            int taskId = config.getTaskPartition();
            List<String> userPaths = GiraphConstants.MESSAGES_DIRECTORY.getList(config);
            Collections.shuffle(userPaths);
            this.directories = new String[userPaths.size()];
            int i = 0;
            for (String path : userPaths) {
                String directory = path + File.separator + jobId + File.separator + taskId + File.separator;
                this.directories[i++] = directory;
                if (new File(directory).mkdirs()) continue;
                LOG.error((Object)("SequentialFileMessageStore$Factory: Failed to create " + directory));
            }
            this.bufferSize = GiraphConstants.MESSAGES_BUFFER_SIZE.get(config);
            this.storeCounter = new AtomicInteger();
        }

        @Override
        public SequentialFileMessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
            int idx = Math.abs(this.storeCounter.getAndIncrement());
            String fileName = this.directories[idx % this.directories.length] + "messages-" + idx;
            return new SequentialFileMessageStore<I, M>(messageValueFactory, this.config, this.bufferSize, fileName);
        }

        @Override
        public void initialize(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
        }

        @Override
        public boolean shouldTraverseMessagesInOrder() {
            return true;
        }
    }
}

