/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.out_of_core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.comm.messages.out_of_core.SequentialFileMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class PartitionDiskBackedMessageStore<I extends WritableComparable, M extends Writable>
implements Writable {
    private final MessageValueFactory<M> messageValueFactory;
    private volatile ConcurrentNavigableMap<I, DataInputOutput> inMemoryMessages;
    private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
    private final AtomicInteger numberOfMessagesInMemory;
    private final Set<I> destinationVertices;
    private final Collection<SequentialFileMessageStore<I, M>> fileStores;
    private final MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> fileStoreFactory;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public PartitionDiskBackedMessageStore(MessageValueFactory<M> messageValueFactory, ImmutableClassesGiraphConfiguration<I, ?, ?> config, MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> fileStoreFactory) {
        this.inMemoryMessages = new ConcurrentSkipListMap<I, DataInputOutput>();
        this.messageValueFactory = messageValueFactory;
        this.config = config;
        this.numberOfMessagesInMemory = new AtomicInteger(0);
        this.destinationVertices = Collections.newSetFromMap(Maps.newConcurrentMap());
        this.fileStores = Lists.newArrayList();
        this.fileStoreFactory = fileStoreFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addVertexMessages(I vertexId, Iterable<M> messages) throws IOException {
        boolean ownsVertexId = false;
        this.destinationVertices.add(vertexId);
        this.rwLock.readLock().lock();
        try {
            DataInputOutput newDataInputOutput;
            DataInputOutput dataInputOutput = (DataInputOutput)this.inMemoryMessages.get(vertexId);
            if (dataInputOutput == null && (dataInputOutput = this.inMemoryMessages.putIfAbsent(vertexId, newDataInputOutput = this.config.createMessagesInputOutput())) == null) {
                ownsVertexId = true;
                dataInputOutput = newDataInputOutput;
            }
            DataInputOutput dataInputOutput2 = dataInputOutput;
            synchronized (dataInputOutput2) {
                for (Writable message : messages) {
                    message.write(dataInputOutput.getDataOutput());
                    this.numberOfMessagesInMemory.getAndIncrement();
                }
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return ownsVertexId;
    }

    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        DataInputOutput dataInputOutput = (DataInputOutput)this.inMemoryMessages.get(vertexId);
        if (dataInputOutput == null) {
            dataInputOutput = this.config.createMessagesInputOutput();
        }
        Iterable<M> combinedIterable = new MessagesIterable<M>(dataInputOutput, this.messageValueFactory);
        for (SequentialFileMessageStore<I, M> fileStore : this.fileStores) {
            combinedIterable = Iterables.concat(combinedIterable, fileStore.getVertexMessages(vertexId));
        }
        return combinedIterable;
    }

    public int getNumberOfMessages() {
        return this.numberOfMessagesInMemory.get();
    }

    public boolean hasMessagesForVertex(I vertexId) {
        return this.destinationVertices.contains(vertexId);
    }

    public Iterable<I> getDestinationVertices() {
        return this.destinationVertices;
    }

    public void clearVertexMessages(I vertexId) throws IOException {
        this.inMemoryMessages.remove(vertexId);
    }

    public void clearAll() throws IOException {
        this.inMemoryMessages.clear();
        this.destinationVertices.clear();
        for (SequentialFileMessageStore<I, M> fileStore : this.fileStores) {
            fileStore.clearAll();
        }
        this.fileStores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        ConcurrentNavigableMap<I, DataInputOutput> messagesToFlush = null;
        this.rwLock.writeLock().lock();
        try {
            messagesToFlush = this.inMemoryMessages;
            this.inMemoryMessages = new ConcurrentSkipListMap<I, DataInputOutput>();
            this.numberOfMessagesInMemory.set(0);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        SequentialFileMessageStore<I, M> fileStore = this.fileStoreFactory.newStore(this.messageValueFactory);
        fileStore.addMessages(messagesToFlush);
        Collection<SequentialFileMessageStore<I, M>> collection = this.fileStores;
        synchronized (collection) {
            this.fileStores.add(fileStore);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.destinationVertices.size());
        for (WritableComparable writableComparable : this.destinationVertices) {
            writableComparable.write(out);
        }
        out.writeInt(this.numberOfMessagesInMemory.get());
        out.writeInt(this.inMemoryMessages.size());
        for (Map.Entry entry : this.inMemoryMessages.entrySet()) {
            ((WritableComparable)entry.getKey()).write(out);
            ((DataInputOutput)entry.getValue()).write(out);
        }
        out.writeInt(this.fileStores.size());
        for (SequentialFileMessageStore sequentialFileMessageStore : this.fileStores) {
            sequentialFileMessageStore.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numVertices = in.readInt();
        for (int v = 0; v < numVertices; ++v) {
            I vertexId = this.config.createVertexId();
            vertexId.readFields(in);
            this.destinationVertices.add(vertexId);
        }
        this.numberOfMessagesInMemory.set(in.readInt());
        int mapSize = in.readInt();
        for (int m = 0; m < mapSize; ++m) {
            I vertexId = this.config.createVertexId();
            vertexId.readFields(in);
            DataInputOutput dataInputOutput = this.config.createMessagesInputOutput();
            dataInputOutput.readFields(in);
            this.inMemoryMessages.put(vertexId, dataInputOutput);
        }
        int numFileStores = in.readInt();
        for (int s = 0; s < numFileStores; ++s) {
            SequentialFileMessageStore<I, M> fileStore = this.fileStoreFactory.newStore(this.messageValueFactory);
            fileStore.readFields(in);
            this.fileStores.add(fileStore);
        }
    }

    public static <I extends WritableComparable, M extends Writable> MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> newFactory(ImmutableClassesGiraphConfiguration<I, ?, ?> config, MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> fileStoreFactory) {
        return new Factory<I, M>(config, fileStoreFactory);
    }

    private static class Factory<I extends WritableComparable, M extends Writable>
    implements MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> {
        private final ImmutableClassesGiraphConfiguration<I, ?, ?> config;
        private final MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> fileStoreFactory;

        public Factory(ImmutableClassesGiraphConfiguration<I, ?, ?> config, MessageStoreFactory<I, M, SequentialFileMessageStore<I, M>> fileStoreFactory) {
            this.config = config;
            this.fileStoreFactory = fileStoreFactory;
        }

        @Override
        public PartitionDiskBackedMessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
            return new PartitionDiskBackedMessageStore<I, M>(messageValueFactory, this.config, this.fileStoreFactory);
        }

        @Override
        public void initialize(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
        }

        @Override
        public boolean shouldTraverseMessagesInOrder() {
            return true;
        }
    }
}

