/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.out_of_core;

import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.out_of_core.DiskBackedMessageStore;
import org.apache.giraph.comm.messages.out_of_core.PartitionDiskBackedMessageStore;
import org.apache.giraph.comm.messages.out_of_core.SequentialFileMessageStore;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class DiskBackedMessageStoreFactory<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
implements MessageStoreFactory<I, M, MessageStore<I, M>> {
    private CentralizedServiceWorker<I, V, E> service;
    private int maxMessagesInMemory;
    private MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> fileStoreFactory;

    public DiskBackedMessageStoreFactory() {
    }

    public DiskBackedMessageStoreFactory(CentralizedServiceWorker<I, V, E> service, int maxMessagesInMemory, MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> fileStoreFactory) {
        this.service = service;
        this.maxMessagesInMemory = maxMessagesInMemory;
        this.fileStoreFactory = fileStoreFactory;
    }

    @Override
    public MessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
        return new DiskBackedMessageStore<I, V, E, M>(messageValueFactory, this.service, this.maxMessagesInMemory, this.fileStoreFactory);
    }

    @Override
    public void initialize(CentralizedServiceWorker service, ImmutableClassesGiraphConfiguration conf) {
        this.maxMessagesInMemory = GiraphConstants.MAX_MESSAGES_IN_MEMORY.get(conf);
        MessageStoreFactory fileMessageStoreFactory = SequentialFileMessageStore.newFactory(conf);
        this.fileStoreFactory = PartitionDiskBackedMessageStore.newFactory(conf, fileMessageStoreFactory);
        this.service = service;
    }

    @Override
    public boolean shouldTraverseMessagesInOrder() {
        return true;
    }
}

