/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.out_of_core;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.out_of_core.DiskBackedMessageStoreFactory;
import org.apache.giraph.comm.messages.out_of_core.PartitionDiskBackedMessageStore;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.EmptyIterable;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class DiskBackedMessageStore<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
implements MessageStore<I, M> {
    private final MessageValueFactory<M> messageValueFactory;
    private final CentralizedServiceWorker<I, V, E> service;
    private final int maxNumberOfMessagesInMemory;
    private final MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> partitionStoreFactory;
    private final ConcurrentMap<Integer, PartitionDiskBackedMessageStore<I, M>> partitionMessageStores;

    public DiskBackedMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, V, E> service, int maxNumberOfMessagesInMemory, MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> partitionStoreFactory) {
        this.messageValueFactory = messageValueFactory;
        this.service = service;
        this.maxNumberOfMessagesInMemory = maxNumberOfMessagesInMemory;
        this.partitionStoreFactory = partitionStoreFactory;
        this.partitionMessageStores = Maps.newConcurrentMap();
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        PartitionDiskBackedMessageStore partitionMessageStore = this.getMessageStore(partitionId);
        VertexIdMessageIterator<I, M> vertexIdMessageIterator = messages.getVertexIdMessageIterator();
        while (vertexIdMessageIterator.hasNext()) {
            vertexIdMessageIterator.next();
            boolean ownsVertexId = partitionMessageStore.addVertexMessages(vertexIdMessageIterator.getCurrentVertexId(), Collections.singleton(vertexIdMessageIterator.getCurrentMessage()));
            if (!ownsVertexId) continue;
            vertexIdMessageIterator.releaseCurrentVertexId();
        }
        this.checkMemory();
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        if (this.hasMessagesForVertex(vertexId)) {
            return this.getMessageStore(vertexId).getVertexMessages(vertexId);
        }
        return EmptyIterable.get();
    }

    @Override
    public boolean hasMessagesForVertex(I vertexId) {
        return this.getMessageStore(vertexId).hasMessagesForVertex(vertexId);
    }

    @Override
    public Iterable<I> getPartitionDestinationVertices(int partitionId) {
        PartitionDiskBackedMessageStore messageStore = (PartitionDiskBackedMessageStore)this.partitionMessageStores.get(partitionId);
        if (messageStore == null) {
            return Collections.emptyList();
        }
        return messageStore.getDestinationVertices();
    }

    @Override
    public void clearVertexMessages(I vertexId) throws IOException {
        if (this.hasMessagesForVertex(vertexId)) {
            this.getMessageStore(vertexId).clearVertexMessages(vertexId);
        }
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        PartitionDiskBackedMessageStore messageStore = (PartitionDiskBackedMessageStore)this.partitionMessageStores.get(partitionId);
        if (messageStore != null) {
            messageStore.clearAll();
        }
    }

    @Override
    public void clearAll() throws IOException {
        for (PartitionDiskBackedMessageStore messageStore : this.partitionMessageStores.values()) {
            messageStore.clearAll();
        }
        this.partitionMessageStores.clear();
    }

    private void checkMemory() throws IOException {
        while (this.memoryFull()) {
            this.flushOnePartition();
        }
    }

    private boolean memoryFull() {
        int totalMessages = 0;
        for (PartitionDiskBackedMessageStore messageStore : this.partitionMessageStores.values()) {
            totalMessages += messageStore.getNumberOfMessages();
        }
        return totalMessages > this.maxNumberOfMessagesInMemory;
    }

    private void flushOnePartition() throws IOException {
        int maxMessages = 0;
        PartitionDiskBackedMessageStore biggestStore = null;
        for (PartitionDiskBackedMessageStore messageStore : this.partitionMessageStores.values()) {
            int numMessages = messageStore.getNumberOfMessages();
            if (numMessages <= maxMessages) continue;
            maxMessages = numMessages;
            biggestStore = messageStore;
        }
        if (biggestStore != null) {
            biggestStore.flush();
        }
    }

    private PartitionDiskBackedMessageStore<I, M> getMessageStore(I vertexId) {
        int partitionId = this.service.getVertexPartitionOwner(vertexId).getPartitionId();
        return this.getMessageStore(partitionId);
    }

    private PartitionDiskBackedMessageStore<I, M> getMessageStore(int partitionId) {
        PartitionDiskBackedMessageStore<I, M> messageStore = (PartitionDiskBackedMessageStore<I, M>)this.partitionMessageStores.get(partitionId);
        if (messageStore != null) {
            return messageStore;
        }
        messageStore = this.partitionStoreFactory.newStore(this.messageValueFactory);
        PartitionDiskBackedMessageStore<I, M> store = this.partitionMessageStores.putIfAbsent(partitionId, messageStore);
        return store == null ? messageStore : store;
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        PartitionDiskBackedMessageStore partitionStore = (PartitionDiskBackedMessageStore)this.partitionMessageStores.get(partitionId);
        out.writeBoolean(partitionStore != null);
        if (partitionStore != null) {
            partitionStore.write(out);
        }
    }

    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        if (in.readBoolean()) {
            PartitionDiskBackedMessageStore<I, M> messageStore = this.partitionStoreFactory.newStore(this.messageValueFactory);
            messageStore.readFields(in);
            this.partitionMessageStores.put(partitionId, messageStore);
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable> MessageStoreFactory<I, M, MessageStore<I, M>> newFactory(CentralizedServiceWorker<I, V, E> service, int maxMessagesInMemory, MessageStoreFactory<I, M, PartitionDiskBackedMessageStore<I, M>> fileStoreFactory) {
        return new DiskBackedMessageStoreFactory<I, V, E, M>(service, maxMessagesInMemory, fileStoreFactory);
    }
}

