/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class SimpleMessageStore<I extends WritableComparable, M extends Writable, T>
implements MessageStore<I, M> {
    protected final MessageValueFactory<M> messageValueFactory;
    protected final CentralizedServiceWorker<I, ?, ?> service;
    protected final ConcurrentMap<Integer, ConcurrentMap<I, T>> map;
    protected final ImmutableClassesGiraphConfiguration<I, ?, ?> config;

    public SimpleMessageStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        this.messageValueFactory = messageValueFactory;
        this.service = service;
        this.config = config;
        this.map = new MapMaker().concurrencyLevel(config.getNettyServerExecutionConcurrency()).makeMap();
    }

    protected abstract Iterable<M> getMessagesAsIterable(T var1);

    protected abstract int getNumberOfMessagesIn(ConcurrentMap<I, T> var1);

    protected abstract void writeMessages(T var1, DataOutput var2) throws IOException;

    protected abstract T readFieldsForMessages(DataInput var1) throws IOException;

    protected int getPartitionId(I vertexId) {
        return this.service.getVertexPartitionOwner(vertexId).getPartitionId();
    }

    protected ConcurrentMap<I, T> getOrCreatePartitionMap(int partitionId) {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(partitionId);
        if (partitionMap == null) {
            ConcurrentMap tmpMap = new MapMaker().concurrencyLevel(this.config.getNettyServerExecutionConcurrency()).makeMap();
            partitionMap = this.map.putIfAbsent(partitionId, tmpMap);
            if (partitionMap == null) {
                partitionMap = tmpMap;
            }
        }
        return partitionMap;
    }

    @Override
    public void finalizeStore() {
    }

    @Override
    public Iterable<I> getPartitionDestinationVertices(int partitionId) {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(partitionId);
        return partitionMap == null ? Collections.emptyList() : partitionMap.keySet();
    }

    @Override
    public boolean hasMessagesForVertex(I vertexId) {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(this.getPartitionId(vertexId));
        return partitionMap != null && partitionMap.containsKey(vertexId);
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(this.getPartitionId(vertexId));
        if (partitionMap == null) {
            return Collections.emptyList();
        }
        Object messages = partitionMap.get(vertexId);
        return messages == null ? Collections.emptyList() : this.getMessagesAsIterable(messages);
    }

    @Override
    public void writePartition(DataOutput out, int partitionId) throws IOException {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(partitionId);
        out.writeBoolean(partitionMap != null);
        if (partitionMap != null) {
            out.writeInt(partitionMap.size());
            for (Map.Entry entry : partitionMap.entrySet()) {
                ((WritableComparable)entry.getKey()).write(out);
                this.writeMessages(entry.getValue(), out);
            }
        }
    }

    @Override
    public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        if (in.readBoolean()) {
            ConcurrentMap partitionMap = Maps.newConcurrentMap();
            int numVertices = in.readInt();
            for (int v = 0; v < numVertices; ++v) {
                I vertexId = this.config.createVertexId();
                vertexId.readFields(in);
                partitionMap.put(vertexId, this.readFieldsForMessages(in));
            }
            this.map.put(partitionId, partitionMap);
        }
    }

    @Override
    public void clearVertexMessages(I vertexId) throws IOException {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(this.getPartitionId(vertexId));
        if (partitionMap != null) {
            partitionMap.remove(vertexId);
        }
    }

    @Override
    public void clearPartition(int partitionId) throws IOException {
        this.map.remove(partitionId);
    }

    @Override
    public void clearAll() throws IOException {
        this.map.clear();
    }
}

