/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.AbstractListPerVertexStore;
import org.apache.giraph.comm.messages.PointerListMessagesIterable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.ExtendedByteArrayOutputBuffer;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class PointerListPerVertexStore<I extends WritableComparable, M extends Writable>
extends AbstractListPerVertexStore<I, M, LongArrayList> {
    private final ExtendedByteArrayOutputBuffer bytesBuffer;

    public PointerListPerVertexStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        super(messageValueFactory, service, config);
        this.bytesBuffer = new ExtendedByteArrayOutputBuffer(config);
    }

    @Override
    public boolean isPointerListEncoding() {
        return true;
    }

    @Override
    protected LongArrayList createList() {
        return new LongArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        VertexIdMessageIterator<I, M> vertexIdMessageIterator = messages.getVertexIdMessageIterator();
        long pointer = 0L;
        while (vertexIdMessageIterator.hasNext()) {
            vertexIdMessageIterator.next();
            M msg = vertexIdMessageIterator.getCurrentMessage();
            LongArrayList list = (LongArrayList)this.getOrCreateList(vertexIdMessageIterator);
            if (vertexIdMessageIterator.isNewMessage()) {
                ExtendedByteArrayOutputBuffer.IndexAndDataOut indexAndDataOut = this.bytesBuffer.getIndexAndDataOut();
                pointer = indexAndDataOut.getIndex();
                pointer <<= 32;
                ExtendedDataOutput dataOutput = indexAndDataOut.getDataOutput();
                pointer += (long)dataOutput.getPos();
                msg.write((DataOutput)dataOutput);
            }
            LongArrayList longArrayList = list;
            synchronized (longArrayList) {
                list.add(pointer);
            }
        }
    }

    @Override
    public Iterable<M> getMessagesAsIterable(LongArrayList pointers) {
        return new PointerListMessagesIterable(this.messageValueFactory, pointers, this.bytesBuffer);
    }

    @Override
    protected int getNumberOfMessagesIn(ConcurrentMap<I, LongArrayList> partitionMap) {
        int numberOfMessages = 0;
        for (LongArrayList list : partitionMap.values()) {
            numberOfMessages += list.size();
        }
        return numberOfMessages;
    }

    @Override
    protected void writeMessages(LongArrayList messages, DataOutput out) throws IOException {
    }

    @Override
    protected LongArrayList readFieldsForMessages(DataInput in) throws IOException {
        return null;
    }
}

