/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.ExtendedByteArrayOutputBuffer;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.UnsafeReusableByteArrayInput;
import org.apache.hadoop.io.Writable;

public class PointerListMessagesIterable<M extends Writable>
implements Iterable<M> {
    private final MessageValueFactory<M> messageValueFactory;
    private final LongArrayList pointers;
    private final ExtendedByteArrayOutputBuffer msgBuffer;
    private final UnsafeReusableByteArrayInput messageReader;

    public PointerListMessagesIterable(MessageValueFactory<M> messageValueFactory, LongArrayList pointers, ExtendedByteArrayOutputBuffer msgBuffer) {
        this.messageValueFactory = messageValueFactory;
        this.pointers = pointers;
        this.msgBuffer = msgBuffer;
        this.messageReader = new UnsafeReusableByteArrayInput();
    }

    protected M createMessage() {
        return (M)this.messageValueFactory.newInstance();
    }

    @Override
    public Iterator<M> iterator() {
        return new Iterator<M>(){
            private final LongListIterator iterator;
            private final M reusableMsg;
            {
                this.iterator = PointerListMessagesIterable.this.pointers.iterator();
                this.reusableMsg = PointerListMessagesIterable.this.createMessage();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public M next() {
                long pointer = (Long)this.iterator.next();
                try {
                    int index = (int)(pointer >>> 32);
                    int offset = (int)pointer;
                    ExtendedDataOutput buffer = PointerListMessagesIterable.this.msgBuffer.getDataOutput(index);
                    PointerListMessagesIterable.this.messageReader.initialize(buffer.getByteArray(), offset, buffer.getPos());
                    this.reusableMsg.readFields((DataInput)PointerListMessagesIterable.this.messageReader);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Got exception : " + e);
                }
                return this.reusableMsg;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

