/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.SimpleMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class OneMessagePerVertexStore<I extends WritableComparable, M extends Writable>
extends SimpleMessageStore<I, M, M> {
    private final MessageCombiner<I, M> messageCombiner;

    public OneMessagePerVertexStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, MessageCombiner<I, M> messageCombiner, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        super(messageValueFactory, service, config);
        this.messageCombiner = messageCombiner;
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        ConcurrentMap partitionMap = this.getOrCreatePartitionMap(partitionId);
        VertexIdMessageIterator<I, M> vertexIdMessageIterator = messages.getVertexIdMessageIterator();
        while (vertexIdMessageIterator.hasNext()) {
            vertexIdMessageIterator.next();
            Object vertexId = vertexIdMessageIterator.getCurrentVertexId();
            Object currentMessage = (Writable)partitionMap.get(vertexIdMessageIterator.getCurrentVertexId());
            if (currentMessage == null) {
                M newMessage = this.messageCombiner.createInitialMessage();
                currentMessage = (Writable)partitionMap.putIfAbsent(vertexIdMessageIterator.releaseCurrentVertexId(), newMessage);
                if (currentMessage == null) {
                    currentMessage = newMessage;
                }
            }
            Writable writable = currentMessage;
            synchronized (writable) {
                this.messageCombiner.combine(vertexId, (Writable)currentMessage, (Writable)vertexIdMessageIterator.getCurrentMessage());
            }
        }
    }

    @Override
    protected Iterable<M> getMessagesAsIterable(M message) {
        return Collections.singleton(message);
    }

    @Override
    protected int getNumberOfMessagesIn(ConcurrentMap<I, M> partitionMap) {
        return partitionMap.size();
    }

    @Override
    protected void writeMessages(M messages, DataOutput out) throws IOException {
        messages.write(out);
    }

    @Override
    protected M readFieldsForMessages(DataInput in) throws IOException {
        Object message = this.messageValueFactory.newInstance();
        message.readFields(in);
        return (M)message;
    }

    public static <I extends WritableComparable, M extends Writable> MessageStoreFactory<I, M, MessageStore<I, M>> newFactory(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        return new Factory(service, config);
    }

    private static class Factory<I extends WritableComparable, M extends Writable>
    implements MessageStoreFactory<I, M, MessageStore<I, M>> {
        private CentralizedServiceWorker<I, ?, ?> service;
        private ImmutableClassesGiraphConfiguration<I, ?, ?> config;

        public Factory(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
            this.service = service;
            this.config = config;
        }

        @Override
        public MessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
            return new OneMessagePerVertexStore<I, M>(messageValueFactory, this.service, this.config.createMessageCombiner(), this.config);
        }

        @Override
        public void initialize(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
            this.service = service;
            this.config = conf;
        }

        @Override
        public boolean shouldTraverseMessagesInOrder() {
            return false;
        }
    }
}

