/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.ByteArrayMessagesPerVertexStore;
import org.apache.giraph.comm.messages.MessageEncodeAndStoreType;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.OneMessagePerVertexStore;
import org.apache.giraph.comm.messages.PointerListPerVertexStore;
import org.apache.giraph.comm.messages.primitives.IdByteArrayMessageStore;
import org.apache.giraph.comm.messages.primitives.IdOneMessagePerVertexStore;
import org.apache.giraph.comm.messages.primitives.IntByteArrayMessageStore;
import org.apache.giraph.comm.messages.primitives.IntFloatMessageStore;
import org.apache.giraph.comm.messages.primitives.LongDoubleMessageStore;
import org.apache.giraph.comm.messages.primitives.long_id.LongByteArrayMessageStore;
import org.apache.giraph.comm.messages.primitives.long_id.LongPointerListMessageStore;
import org.apache.giraph.comm.messages.queue.AsyncMessageStoreWrapper;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.TypeOpsUtils;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class InMemoryMessageStoreFactory<I extends WritableComparable, M extends Writable>
implements MessageStoreFactory<I, M, MessageStore<I, M>> {
    private static final Logger LOG = Logger.getLogger(InMemoryMessageStoreFactory.class);
    protected CentralizedServiceWorker<I, ?, ?> service;
    protected ImmutableClassesGiraphConfiguration<I, ?, ?> conf;

    protected MessageStore<I, M> newStoreWithCombiner(MessageValueFactory<M> messageValueFactory) {
        PrimitiveIdTypeOps<I> idTypeOps;
        Class messageClass = messageValueFactory.getValueClass();
        Class<I> vertexIdClass = this.conf.getVertexIdClass();
        MessageStore<IntWritable, FloatWritable> messageStore = vertexIdClass.equals(IntWritable.class) && messageClass.equals(FloatWritable.class) ? new IntFloatMessageStore(this.service, this.conf.createMessageCombiner()) : (vertexIdClass.equals(LongWritable.class) && messageClass.equals(DoubleWritable.class) ? new LongDoubleMessageStore(this.service, this.conf.createMessageCombiner()) : ((idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOpsOrNull(vertexIdClass)) != null ? new IdOneMessagePerVertexStore<I, M>(messageValueFactory, this.service, this.conf.createMessageCombiner(), this.conf) : new OneMessagePerVertexStore<I, M>(messageValueFactory, this.service, this.conf.createMessageCombiner(), this.conf)));
        return messageStore;
    }

    protected MessageStore<I, M> newStoreWithoutCombiner(MessageValueFactory<M> messageValueFactory) {
        MessageStore messageStore = null;
        MessageEncodeAndStoreType encodeAndStore = GiraphConstants.MESSAGE_ENCODE_AND_STORE_TYPE.get(this.conf);
        Class<I> vertexIdClass = this.conf.getVertexIdClass();
        if (vertexIdClass.equals(IntWritable.class)) {
            messageStore = new IntByteArrayMessageStore<M>(messageValueFactory, this.service, this.conf);
        } else if (vertexIdClass.equals(LongWritable.class)) {
            if (encodeAndStore.equals((Object)MessageEncodeAndStoreType.BYTEARRAY_PER_PARTITION) || encodeAndStore.equals((Object)MessageEncodeAndStoreType.EXTRACT_BYTEARRAY_PER_PARTITION)) {
                messageStore = new LongByteArrayMessageStore<M>(messageValueFactory, this.service, this.conf);
            } else if (encodeAndStore.equals((Object)MessageEncodeAndStoreType.POINTER_LIST_PER_VERTEX)) {
                messageStore = new LongPointerListMessageStore<M>(messageValueFactory, this.service, this.conf);
            }
        } else if (encodeAndStore.equals((Object)MessageEncodeAndStoreType.BYTEARRAY_PER_PARTITION) || encodeAndStore.equals((Object)MessageEncodeAndStoreType.EXTRACT_BYTEARRAY_PER_PARTITION)) {
            PrimitiveIdTypeOps<I> idTypeOps = TypeOpsUtils.getPrimitiveIdTypeOpsOrNull(vertexIdClass);
            messageStore = idTypeOps != null ? new IdByteArrayMessageStore<I, M>(messageValueFactory, this.service, this.conf) : new ByteArrayMessagesPerVertexStore<I, M>(messageValueFactory, this.service, this.conf);
        } else if (encodeAndStore.equals((Object)MessageEncodeAndStoreType.POINTER_LIST_PER_VERTEX)) {
            messageStore = new PointerListPerVertexStore<I, M>(messageValueFactory, this.service, this.conf);
        }
        return messageStore;
    }

    @Override
    public MessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
        int asyncMessageStoreThreads;
        Class messageClass = messageValueFactory.getValueClass();
        MessageStore<I, M> messageStore = this.conf.useMessageCombiner() ? this.newStoreWithCombiner(messageValueFactory) : this.newStoreWithoutCombiner(messageValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("newStore: Created " + messageStore.getClass() + " for vertex id " + this.conf.getVertexIdClass() + " and message value " + messageClass + " and" + (this.conf.useMessageCombiner() ? " message combiner " + this.conf.getMessageCombinerClass() : " no combiner")));
        }
        if ((asyncMessageStoreThreads = GiraphConstants.ASYNC_MESSAGE_STORE_THREADS_COUNT.get(this.conf)) > 0) {
            messageStore = new AsyncMessageStoreWrapper<I, M>(messageStore, this.service.getPartitionStore().getPartitionIds(), asyncMessageStoreThreads);
        }
        return messageStore;
    }

    @Override
    public void initialize(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
        this.service = service;
        this.conf = conf;
    }

    @Override
    public boolean shouldTraverseMessagesInOrder() {
        return false;
    }
}

