/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.MessagesIterable;
import org.apache.giraph.comm.messages.SimpleMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.utils.RepresentativeByteStructIterator;
import org.apache.giraph.utils.VerboseByteStructMessageWrite;
import org.apache.giraph.utils.VertexIdIterator;
import org.apache.giraph.utils.VertexIdMessageBytesIterator;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class ByteArrayMessagesPerVertexStore<I extends WritableComparable, M extends Writable>
extends SimpleMessageStore<I, M, DataInputOutput> {
    public ByteArrayMessagesPerVertexStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        super(messageValueFactory, service, config);
    }

    @Override
    public boolean isPointerListEncoding() {
        return false;
    }

    private DataInputOutput getDataInputOutput(ConcurrentMap<I, DataInputOutput> partitionMap, VertexIdIterator<I> iterator) {
        DataInputOutput dataInputOutput = (DataInputOutput)partitionMap.get(iterator.getCurrentVertexId());
        if (dataInputOutput == null) {
            DataInputOutput newDataOutput = this.config.createMessagesInputOutput();
            dataInputOutput = partitionMap.putIfAbsent(iterator.releaseCurrentVertexId(), newDataOutput);
            if (dataInputOutput == null) {
                dataInputOutput = newDataOutput;
            }
        }
        return dataInputOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitionMessages(int partitionId, VertexIdMessages<I, M> messages) throws IOException {
        ConcurrentMap partitionMap = this.getOrCreatePartitionMap(partitionId);
        VertexIdMessageBytesIterator<I, M> vertexIdMessageBytesIterator = messages.getVertexIdMessageBytesIterator();
        if (vertexIdMessageBytesIterator != null) {
            while (vertexIdMessageBytesIterator.hasNext()) {
                DataInputOutput dataInputOutput;
                vertexIdMessageBytesIterator.next();
                DataInputOutput dataInputOutput2 = dataInputOutput = this.getDataInputOutput(partitionMap, vertexIdMessageBytesIterator);
                synchronized (dataInputOutput2) {
                    vertexIdMessageBytesIterator.writeCurrentMessageBytes(dataInputOutput.getDataOutput());
                }
            }
        } else {
            VertexIdMessageIterator<I, M> vertexIdMessageIterator = messages.getVertexIdMessageIterator();
            while (vertexIdMessageIterator.hasNext()) {
                DataInputOutput dataInputOutput;
                vertexIdMessageIterator.next();
                DataInputOutput dataInputOutput3 = dataInputOutput = this.getDataInputOutput(partitionMap, vertexIdMessageIterator);
                synchronized (dataInputOutput3) {
                    VerboseByteStructMessageWrite.verboseWriteCurrentMessage(vertexIdMessageIterator, dataInputOutput.getDataOutput());
                }
            }
        }
    }

    @Override
    protected Iterable<M> getMessagesAsIterable(DataInputOutput dataInputOutput) {
        return new MessagesIterable(dataInputOutput, this.messageValueFactory);
    }

    @Override
    protected int getNumberOfMessagesIn(ConcurrentMap<I, DataInputOutput> partitionMap) {
        int numberOfMessages = 0;
        for (DataInputOutput dataInputOutput : partitionMap.values()) {
            numberOfMessages += Iterators.size((Iterator)new RepresentativeByteStructIterator<M>(dataInputOutput.createDataInput()){

                @Override
                protected M createWritable() {
                    return ByteArrayMessagesPerVertexStore.this.messageValueFactory.newInstance();
                }
            });
        }
        return numberOfMessages;
    }

    @Override
    protected void writeMessages(DataInputOutput dataInputOutput, DataOutput out) throws IOException {
        dataInputOutput.write(out);
    }

    @Override
    protected DataInputOutput readFieldsForMessages(DataInput in) throws IOException {
        DataInputOutput dataInputOutput = this.config.createMessagesInputOutput();
        dataInputOutput.readFields(in);
        return dataInputOutput;
    }

    public static <I extends WritableComparable, M extends Writable> MessageStoreFactory<I, M, MessageStore<I, M>> newFactory(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        return new Factory(service, config);
    }

    private static class Factory<I extends WritableComparable, M extends Writable>
    implements MessageStoreFactory<I, M, MessageStore<I, M>> {
        private CentralizedServiceWorker<I, ?, ?> service;
        private ImmutableClassesGiraphConfiguration<I, ?, ?> config;

        public Factory(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
            this.service = service;
            this.config = config;
        }

        @Override
        public MessageStore<I, M> newStore(MessageValueFactory<M> messageValueFactory) {
            return new ByteArrayMessagesPerVertexStore<I, M>(messageValueFactory, this.service, this.config);
        }

        @Override
        public void initialize(CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> conf) {
            this.service = service;
            this.config = conf;
        }

        @Override
        public boolean shouldTraverseMessagesInOrder() {
            return false;
        }
    }
}

