/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.SimpleMessageStore;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.VertexIdIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class AbstractListPerVertexStore<I extends WritableComparable, M extends Writable, L extends List>
extends SimpleMessageStore<I, M, L> {
    public AbstractListPerVertexStore(MessageValueFactory<M> messageValueFactory, CentralizedServiceWorker<I, ?, ?> service, ImmutableClassesGiraphConfiguration<I, ?, ?> config) {
        super(messageValueFactory, service, config);
    }

    protected abstract L createList();

    protected L getOrCreateList(VertexIdIterator<I> iterator) {
        PartitionOwner owner = this.service.getVertexPartitionOwner(iterator.getCurrentVertexId());
        int partitionId = owner.getPartitionId();
        ConcurrentMap partitionMap = this.getOrCreatePartitionMap(partitionId);
        List<Object> list = (List)partitionMap.get(iterator.getCurrentVertexId());
        if (list == null) {
            L newList = this.createList();
            list = (List)partitionMap.putIfAbsent(iterator.releaseCurrentVertexId(), newList);
            if (list == null) {
                list = newList;
            }
        }
        return (L)list;
    }

    @Override
    public Iterable<M> getVertexMessages(I vertexId) throws IOException {
        ConcurrentMap partitionMap = (ConcurrentMap)this.map.get(this.getPartitionId(vertexId));
        if (partitionMap == null) {
            return Collections.emptyList();
        }
        List list = (List)partitionMap.get(vertexId);
        return list == null ? Collections.emptyList() : this.getMessagesAsIterable(list);
    }
}

