/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.aggregators.CountingCache;
import org.apache.giraph.comm.aggregators.GlobalCommValueOutputStream;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class SendGlobalCommCache
extends CountingCache {
    private final Map<Integer, GlobalCommValueOutputStream> globalCommMap = Maps.newHashMap();
    private final boolean writeClass;

    public SendGlobalCommCache(boolean writeClass) {
        this.writeClass = writeClass;
    }

    public int addValue(Integer taskId, String name, GlobalCommType type, Writable value) throws IOException {
        GlobalCommValueOutputStream out = this.globalCommMap.get(taskId);
        if (out == null) {
            out = new GlobalCommValueOutputStream(this.writeClass);
            this.globalCommMap.put(taskId, out);
        }
        return out.addValue(name, type, value);
    }

    public byte[] removeSerialized(Integer taskId) {
        this.incrementCounter(taskId);
        GlobalCommValueOutputStream out = this.globalCommMap.remove(taskId);
        if (out == null) {
            return new byte[4];
        }
        return out.flush();
    }

    public void addSpecialCount(Integer taskId) throws IOException {
        long totalCount = this.getCount(taskId) + 1L;
        this.addValue(taskId, GlobalCommType.SPECIAL_COUNT.name(), GlobalCommType.SPECIAL_COUNT, (Writable)new LongWritable(totalCount));
    }
}

