/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.giraph.reducers.Reducer;
import org.apache.giraph.utils.TaskIdsPermitsBarrier;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class OwnerAggregatorServerData {
    private static final Logger LOG = Logger.getLogger(OwnerAggregatorServerData.class);
    private final ConcurrentMap<String, Reducer<Object, Writable>> myReducerMap = Maps.newConcurrentMap();
    private final TaskIdsPermitsBarrier workersBarrier;
    private final Progressable progressable;

    public OwnerAggregatorServerData(Progressable progressable) {
        this.progressable = progressable;
        this.workersBarrier = new TaskIdsPermitsBarrier(progressable);
    }

    public void registerReducer(String name, ReduceOperation<Object, Writable> reduceOp) {
        if (LOG.isDebugEnabled() && this.myReducerMap.isEmpty()) {
            LOG.debug((Object)"registerAggregator: The first registration after a reset()");
        }
        this.myReducerMap.putIfAbsent(name, new Reducer<Object, Writable>(reduceOp));
        this.progressable.progress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduce(String name, Writable value) {
        Reducer reducer;
        Reducer reducer2 = reducer = (Reducer)this.myReducerMap.get(name);
        synchronized (reducer2) {
            reducer.reducePartial(value);
        }
        this.progressable.progress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable createInitialValue(String name) {
        Reducer reducer;
        Reducer reducer2 = reducer = (Reducer)this.myReducerMap.get(name);
        synchronized (reducer2) {
            return reducer.createInitialValue();
        }
    }

    public void receivedRequestFromWorker() {
        this.workersBarrier.releaseOnePermit();
    }

    public void receivedRequestCountFromWorker(long requestCount, int taskId) {
        this.workersBarrier.requirePermits(requestCount, taskId);
    }

    public Iterable<Map.Entry<String, Writable>> getMyReducedValuesWhenReady(Set<Integer> workerIds) {
        this.workersBarrier.waitForRequiredPermits(workerIds);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getMyAggregatorValuesWhenReady: Values ready");
        }
        return Iterables.transform(this.myReducerMap.entrySet(), (Function)new Function<Map.Entry<String, Reducer<Object, Writable>>, Map.Entry<String, Writable>>(){

            public Map.Entry<String, Writable> apply(Map.Entry<String, Reducer<Object, Writable>> aggregator) {
                return new AbstractMap.SimpleEntry<String, Writable>(aggregator.getKey(), aggregator.getValue().getCurrentValue());
            }
        });
    }

    public void reset() {
        this.myReducerMap.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"reset: Ready for next superstep");
        }
    }
}

