/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.aggregators.CountingOutputStream;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;

public class GlobalCommValueOutputStream
extends CountingOutputStream {
    private final boolean writeClass;

    public GlobalCommValueOutputStream(boolean writeClass) {
        this.writeClass = writeClass;
    }

    public int addValue(String name, GlobalCommType type, Writable value) throws IOException {
        this.incrementCounter();
        this.dataOutput.writeUTF(name);
        this.dataOutput.writeByte(type.ordinal());
        if (this.writeClass) {
            WritableUtils.writeWritableObject(value, this.dataOutput);
        } else {
            value.write((DataOutput)this.dataOutput);
        }
        return this.getSize();
    }
}

