/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import java.io.IOException;
import org.apache.giraph.utils.ExtendedByteArrayDataOutput;
import org.apache.giraph.utils.ExtendedDataOutput;

public abstract class CountingOutputStream {
    protected ExtendedDataOutput dataOutput = new ExtendedByteArrayDataOutput();
    private int counter;

    public CountingOutputStream() {
        this.reset();
    }

    protected void incrementCounter() {
        ++this.counter;
    }

    protected int getSize() {
        return this.dataOutput.getPos();
    }

    public byte[] flush() {
        this.dataOutput.writeInt(0, this.counter);
        byte[] ret = this.dataOutput.toByteArray();
        this.reset();
        return ret;
    }

    private void reset() {
        this.dataOutput.reset();
        try {
            this.dataOutput.writeInt(0);
        }
        catch (IOException e) {
            throw new IllegalStateException("reset: Got IOException", e);
        }
        this.counter = 0;
    }
}

