/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import com.google.common.collect.Maps;
import java.util.Map;

public abstract class CountingCache {
    private Map<Integer, Long> countMap = Maps.newHashMap();

    protected void incrementCounter(Integer taskId) {
        Long currentCount = this.countMap.get(taskId);
        this.countMap.put(taskId, currentCount == null ? 1L : currentCount + 1L);
    }

    protected long getCount(Integer taskId) {
        Long count = this.countMap.get(taskId);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void reset() {
        this.countMap.clear();
    }
}

