/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.master.MasterInfo;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.giraph.reducers.Reducer;
import org.apache.giraph.utils.TaskIdsPermitsBarrier;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class AllAggregatorServerData {
    private static final Logger LOG = Logger.getLogger(AllAggregatorServerData.class);
    private final ConcurrentMap<String, Writable> broadcastedMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, ReduceOperation<Object, Writable>> reduceOpMap = Maps.newConcurrentMap();
    private final TaskIdsPermitsBarrier masterBarrier;
    private final List<byte[]> masterData = Collections.synchronizedList(Lists.newArrayList());
    private final TaskIdsPermitsBarrier workersBarrier;
    private final Progressable progressable;
    private final ImmutableClassesGiraphConfiguration conf;

    public AllAggregatorServerData(Progressable progressable, ImmutableClassesGiraphConfiguration conf) {
        this.progressable = progressable;
        this.conf = conf;
        this.workersBarrier = new TaskIdsPermitsBarrier(progressable);
        this.masterBarrier = new TaskIdsPermitsBarrier(progressable);
    }

    public void receiveValueFromMaster(String name, GlobalCommType type, Writable value) {
        switch (type) {
            case BROADCAST: {
                this.broadcastedMap.put(name, value);
                break;
            }
            case REDUCE_OPERATIONS: {
                this.reduceOpMap.put(name, (ReduceOperation)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown request type " + (Object)((Object)type));
            }
        }
        this.progressable.progress();
    }

    public void receivedRequestFromMaster(byte[] data) {
        this.masterData.add(data);
        this.masterBarrier.releaseOnePermit();
    }

    public void receivedRequestCountFromMaster(long requestCount, int taskId) {
        this.masterBarrier.requirePermits(requestCount, taskId);
    }

    public void receivedRequestFromWorker() {
        this.workersBarrier.releaseOnePermit();
    }

    public void receivedRequestCountFromWorker(long requestCount, int taskId) {
        this.workersBarrier.requirePermits(requestCount, taskId);
    }

    public Iterable<byte[]> getDataFromMasterWhenReady(MasterInfo masterInfo) {
        this.masterBarrier.waitForRequiredPermits(Collections.singleton(masterInfo.getTaskId()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getDataFromMasterWhenReady: Aggregator data for distribution ready");
        }
        return this.masterData;
    }

    public void fillNextSuperstepMapsWhenReady(Set<Integer> workerIds, Map<String, Writable> broadcastedMapToFill, Map<String, Reducer<Object, Writable>> reducerMapToFill) {
        this.workersBarrier.waitForRequiredPermits(workerIds);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"fillNextSuperstepMapsWhenReady: Global data ready");
        }
        Preconditions.checkArgument((boolean)broadcastedMapToFill.isEmpty(), (Object)"broadcastedMap needs to be empty for filling");
        Preconditions.checkArgument((boolean)reducerMapToFill.isEmpty(), (Object)"reducerMap needs to be empty for filling");
        broadcastedMapToFill.putAll(this.broadcastedMap);
        for (Map.Entry entry : this.reduceOpMap.entrySet()) {
            reducerMapToFill.put((String)entry.getKey(), new Reducer((ReduceOperation)entry.getValue()));
        }
        this.broadcastedMap.clear();
        this.reduceOpMap.clear();
        this.masterData.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"reset: Ready for next superstep");
        }
    }
}

