/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.aggregators;

import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.worker.WorkerInfo;

public class AggregatorUtils {
    public static final String MAX_BYTES_PER_AGGREGATOR_REQUEST = "giraph.maxBytesPerAggregatorRequest";
    public static final int MAX_BYTES_PER_AGGREGATOR_REQUEST_DEFAULT = 0x100000;
    public static final String USE_THREAD_LOCAL_AGGREGATORS = "giraph.useThreadLocalAggregators";
    public static final boolean USE_THREAD_LOCAL_AGGREGATORS_DEFAULT = false;

    private AggregatorUtils() {
    }

    public static WorkerInfo getOwner(String aggregatorName, List<WorkerInfo> workers) {
        int index = Math.abs(aggregatorName.hashCode() % workers.size());
        return workers.get(index);
    }

    public static boolean useThreadLocalAggregators(ImmutableClassesGiraphConfiguration conf) {
        return conf.getBoolean(USE_THREAD_LOCAL_AGGREGATORS, false);
    }

    public static String getUnregisteredAggregatorMessage(String aggregatorName, boolean hasRegisteredAggregators, ImmutableClassesGiraphConfiguration conf) {
        String message = "Tried to access aggregator which wasn't registered " + aggregatorName;
        if (!hasRegisteredAggregators) {
            message = message + "; Aggregators can be registered in " + "MasterCompute.initialize by calling " + "registerAggregator(aggregatorName, aggregatorClass). " + "Also be sure that you are correctly setting MasterCompute class, " + "currently using " + conf.getMasterComputeClass().getName();
        }
        return message;
    }

    public static String getUnregisteredReducerMessage(String reducerName, boolean hasRegisteredReducers, ImmutableClassesGiraphConfiguration conf) {
        String message = "Tried to access reducer which wasn't registered " + reducerName;
        if (!hasRegisteredReducers) {
            message = message + "; Aggregators can be registered from " + "MasterCompute by calling registerReducer function. " + "Also be sure that you are correctly setting MasterCompute class, " + "currently using " + conf.getMasterComputeClass().getName();
        }
        return message;
    }

    public static String getUnregisteredBroadcastMessage(String broadcastName, boolean hasBroadcasted, ImmutableClassesGiraphConfiguration conf) {
        String message = "Tried to access broadcast which wasn't set before " + broadcastName;
        if (!hasBroadcasted) {
            message = message + "; Values can be broadcasted from " + "MasterCompute by calling broadcast function. " + "Also be sure that you are correctly setting MasterCompute class, " + "currently using " + conf.getMasterComputeClass().getName();
        }
        return message;
    }
}

