/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.aggregators.AllAggregatorServerData;
import org.apache.giraph.comm.aggregators.OwnerAggregatorServerData;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.queue.AsyncMessageStoreWrapper;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeStore;
import org.apache.giraph.edge.EdgeStoreFactory;
import org.apache.giraph.graph.VertexMutations;
import org.apache.giraph.partition.DiskBackedPartitionStore;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.partition.SimplePartitionStore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;

public class ServerData<I extends WritableComparable, V extends Writable, E extends Writable> {
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private volatile PartitionStore<I, V, E> partitionStore;
    private final EdgeStore<I, V, E> edgeStore;
    private final MessageStoreFactory<I, Writable, MessageStore<I, Writable>> messageStoreFactory;
    private volatile MessageStore<I, Writable> incomingMessageStore;
    private volatile MessageStore<I, Writable> currentMessageStore;
    private final ConcurrentHashMap<I, VertexMutations<I, V, E>> vertexMutations = new ConcurrentHashMap();
    private final OwnerAggregatorServerData ownerAggregatorData;
    private final AllAggregatorServerData allAggregatorData;
    private final CentralizedServiceWorker<I, V, E> serviceWorker;
    private volatile List<Writable> currentWorkerToWorkerMessages = Collections.synchronizedList(new ArrayList());
    private volatile List<Writable> incomingWorkerToWorkerMessages = Collections.synchronizedList(new ArrayList());

    public ServerData(CentralizedServiceWorker<I, V, E> service, ImmutableClassesGiraphConfiguration<I, V, E> conf, MessageStoreFactory<I, Writable, MessageStore<I, Writable>> messageStoreFactory, Mapper.Context context) {
        this.serviceWorker = service;
        this.conf = conf;
        this.messageStoreFactory = messageStoreFactory;
        this.partitionStore = GiraphConstants.USE_OUT_OF_CORE_GRAPH.get(conf) ? new DiskBackedPartitionStore<I, V, E>(conf, context, this.getServiceWorker()) : new SimplePartitionStore<I, V, E>(conf, context);
        EdgeStoreFactory<I, V, E> edgeStoreFactory = conf.createEdgeStoreFactory();
        edgeStoreFactory.initialize(service, conf, (Progressable)context);
        this.edgeStore = edgeStoreFactory.newStore();
        this.ownerAggregatorData = new OwnerAggregatorServerData((Progressable)context);
        this.allAggregatorData = new AllAggregatorServerData((Progressable)context, conf);
    }

    public EdgeStore<I, V, E> getEdgeStore() {
        return this.edgeStore;
    }

    public PartitionStore<I, V, E> getPartitionStore() {
        return this.partitionStore;
    }

    public <M extends Writable> MessageStore<I, M> getIncomingMessageStore() {
        return this.incomingMessageStore;
    }

    public <M extends Writable> MessageStore<I, M> getCurrentMessageStore() {
        return this.currentMessageStore;
    }

    public void resetMessageStores() throws IOException {
        if (this.currentMessageStore != null) {
            this.currentMessageStore.clearAll();
            this.currentMessageStore = null;
        }
        if (this.incomingMessageStore != null) {
            this.incomingMessageStore.clearAll();
            this.incomingMessageStore = null;
        }
        this.prepareSuperstep();
    }

    public void prepareSuperstep() {
        if (this.currentMessageStore != null) {
            try {
                this.currentMessageStore.clearAll();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to clear previous message store");
            }
        }
        this.currentMessageStore = this.incomingMessageStore != null ? this.incomingMessageStore : this.messageStoreFactory.newStore(this.conf.getIncomingMessageValueFactory());
        this.incomingMessageStore = this.messageStoreFactory.newStore(this.conf.getOutgoingMessageValueFactory());
        this.currentMessageStore.finalizeStore();
        this.currentWorkerToWorkerMessages = this.incomingWorkerToWorkerMessages;
        this.incomingWorkerToWorkerMessages = Collections.synchronizedList(new ArrayList());
    }

    public void waitForComplete() {
        if (this.incomingMessageStore instanceof AsyncMessageStoreWrapper) {
            ((AsyncMessageStoreWrapper)this.incomingMessageStore).waitToComplete();
        }
    }

    public ConcurrentHashMap<I, VertexMutations<I, V, E>> getVertexMutations() {
        return this.vertexMutations;
    }

    public OwnerAggregatorServerData getOwnerAggregatorData() {
        return this.ownerAggregatorData;
    }

    public AllAggregatorServerData getAllAggregatorData() {
        return this.allAggregatorData;
    }

    public CentralizedServiceWorker<I, V, E> getServiceWorker() {
        return this.serviceWorker;
    }

    public List<Writable> getAndClearCurrentWorkerToWorkerMessages() {
        List<Writable> ret = this.currentWorkerToWorkerMessages;
        this.currentWorkerToWorkerMessages = null;
        return ret;
    }

    public void addIncomingWorkerToWorkerMessage(Writable message) {
        this.incomingWorkerToWorkerMessages.add(message);
    }

    public List<Writable> getCurrentWorkerToWorkerMessages() {
        return this.currentWorkerToWorkerMessages;
    }
}

