/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendDataCache;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.VertexIdData;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.WritableComparable;

@NotThreadSafe
public abstract class SendVertexIdDataCache<I extends WritableComparable, T, B extends VertexIdData<I, T>>
extends SendDataCache<B> {
    public SendVertexIdDataCache(ImmutableClassesGiraphConfiguration conf, CentralizedServiceWorker<?, ?, ?> serviceWorker, int maxRequestSize, float additionalRequestSize) {
        super(conf, serviceWorker, maxRequestSize, additionalRequestSize);
    }

    public abstract B createVertexIdData();

    public int addData(WorkerInfo workerInfo, int partitionId, I destVertexId, T data) {
        VertexIdData<I, T> partitionData = this.getPartitionData(workerInfo, partitionId);
        int originalSize = partitionData.getSize();
        partitionData.add(destVertexId, data);
        return this.incrDataSize(workerInfo.getTaskId(), partitionData.getSize() - originalSize);
    }

    public int addData(WorkerInfo workerInfo, int partitionId, byte[] serializedId, int idPos, T data) {
        VertexIdData<I, T> partitionData = this.getPartitionData(workerInfo, partitionId);
        int originalSize = partitionData.getSize();
        partitionData.add(serializedId, idPos, data);
        return this.incrDataSize(workerInfo.getTaskId(), partitionData.getSize() - originalSize);
    }

    private VertexIdData<I, T> getPartitionData(WorkerInfo workerInfo, int partitionId) {
        VertexIdData partitionData = (VertexIdData)this.getData(partitionId);
        if (partitionData == null) {
            partitionData = this.createVertexIdData();
            partitionData.setConf(this.getConf());
            partitionData.initialize(this.getInitialBufferSize(workerInfo.getTaskId()));
            this.setData(partitionId, partitionData);
        }
        return partitionData;
    }
}

