/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import java.io.IOException;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendDataCache;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SendPartitionCache<I extends WritableComparable, V extends Writable, E extends Writable>
extends SendDataCache<ExtendedDataOutput> {
    private static final Logger LOG = Logger.getLogger(SendPartitionCache.class);

    public SendPartitionCache(ImmutableClassesGiraphConfiguration<I, V, E> conf, CentralizedServiceWorker<?, ?, ?> serviceWorker) {
        super(conf, serviceWorker, GiraphConstants.MAX_VERTEX_REQUEST_SIZE.get(conf), GiraphConstants.ADDITIONAL_VERTEX_REQUEST_SIZE.get(conf));
    }

    public int addVertex(PartitionOwner partitionOwner, Vertex<I, V, E> vertex) {
        ExtendedDataOutput partitionData = (ExtendedDataOutput)this.getData(partitionOwner.getPartitionId());
        int taskId = partitionOwner.getWorkerInfo().getTaskId();
        int originalSize = 0;
        if (partitionData == null) {
            partitionData = this.getConf().createExtendedDataOutput(this.getInitialBufferSize(taskId));
            this.setData(partitionOwner.getPartitionId(), partitionData);
        } else {
            originalSize = partitionData.getPos();
        }
        try {
            WritableUtils.writeVertexToDataOutput(partitionData, vertex, this.getConf());
        }
        catch (IOException e) {
            throw new IllegalStateException("addVertex: Failed to serialize", e);
        }
        return this.incrDataSize(taskId, partitionData.getPos() - originalSize);
    }
}

