/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendMessageCache;
import org.apache.giraph.comm.netty.NettyWorkerClientRequestProcessor;
import org.apache.giraph.comm.requests.SendWorkerMessagesRequest;
import org.apache.giraph.comm.requests.SendWorkerOneMessageToManyRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.ByteArrayOneMessageToManyIds;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

@NotThreadSafe
public class SendOneMessageToManyCache<I extends WritableComparable, M extends Writable>
extends SendMessageCache<I, M> {
    private static final Logger LOG = Logger.getLogger(SendOneMessageToManyCache.class);
    private final ByteArrayOneMessageToManyIds<I, M>[] msgVidsCache;
    private final int[] msgVidsSizes;
    private final ExtendedDataOutput[] idSerializer;
    private final int[] idCounter;
    private final int[] firstPartitionMap;
    private final WorkerInfo[] workerInfoList;

    public SendOneMessageToManyCache(ImmutableClassesGiraphConfiguration conf, CentralizedServiceWorker<?, ?, ?> serviceWorker, NettyWorkerClientRequestProcessor<I, ?, ?> processor, int maxMsgSize) {
        super(conf, serviceWorker, processor, maxMsgSize);
        int numWorkers = this.getNumWorkers();
        this.msgVidsCache = new ByteArrayOneMessageToManyIds[numWorkers];
        this.msgVidsSizes = new int[numWorkers];
        this.idSerializer = new ExtendedDataOutput[numWorkers];
        int initialBufferSize = 0;
        for (int i = 0; i < this.idSerializer.length; ++i) {
            initialBufferSize = this.getSendWorkerInitialBufferSize(i);
            if (initialBufferSize <= 0) continue;
            this.idSerializer[i] = conf.createExtendedDataOutput(initialBufferSize);
        }
        this.idCounter = new int[numWorkers];
        this.firstPartitionMap = new int[numWorkers];
        this.workerInfoList = new WorkerInfo[numWorkers];
        Iterator<WorkerInfo> i$ = serviceWorker.getWorkerInfoList().iterator();
        while (i$.hasNext()) {
            WorkerInfo workerInfo;
            this.workerInfoList[workerInfo.getTaskId()] = workerInfo = i$.next();
        }
    }

    private void resetIdSerializers() {
        for (int i = 0; i < this.idSerializer.length; ++i) {
            if (this.idSerializer[i] == null) continue;
            this.idSerializer[i].reset();
        }
    }

    private void resetIdCounter() {
        Arrays.fill(this.idCounter, 0);
    }

    private int addOneToManyMessage(WorkerInfo workerInfo, byte[] ids, int idPos, int count, M message) {
        ByteArrayOneMessageToManyIds<I, M> workerData = this.msgVidsCache[workerInfo.getTaskId()];
        if (workerData == null) {
            workerData = new ByteArrayOneMessageToManyIds(this.getConf().getOutgoingMessageValueFactory());
            workerData.setConf(this.getConf());
            workerData.initialize(this.getSendWorkerInitialBufferSize(workerInfo.getTaskId()));
            this.msgVidsCache[workerInfo.getTaskId()] = workerData;
        }
        workerData.add(ids, idPos, count, message);
        this.msgVidsSizes[workerInfo.getTaskId()] = workerData.getSize();
        return this.msgVidsSizes[workerInfo.getTaskId()];
    }

    private ByteArrayOneMessageToManyIds<I, M> removeWorkerMsgVids(WorkerInfo workerInfo) {
        ByteArrayOneMessageToManyIds<I, M> workerData = this.msgVidsCache[workerInfo.getTaskId()];
        if (workerData != null) {
            this.msgVidsCache[workerInfo.getTaskId()] = null;
            this.msgVidsSizes[workerInfo.getTaskId()] = 0;
        }
        return workerData;
    }

    private PairList<WorkerInfo, ByteArrayOneMessageToManyIds<I, M>> removeAllMsgVids() {
        PairList<WorkerInfo, ByteArrayOneMessageToManyIds<I, M>> allData = new PairList<WorkerInfo, ByteArrayOneMessageToManyIds<I, M>>();
        allData.initialize(this.msgVidsCache.length);
        for (WorkerInfo workerInfo : this.getWorkerPartitions().keySet()) {
            ByteArrayOneMessageToManyIds<I, M> workerData = this.removeWorkerMsgVids(workerInfo);
            if (workerData == null || workerData.isEmpty()) continue;
            allData.add(workerInfo, workerData);
        }
        return allData;
    }

    @Override
    public void sendMessageToAllRequest(Iterator<I> vertexIdIterator, M message) {
        this.resetIdSerializers();
        this.resetIdCounter();
        int currentMachineId = 0;
        PartitionOwner owner = null;
        WorkerInfo workerInfo = null;
        WritableComparable vertexId = null;
        while (vertexIdIterator.hasNext()) {
            vertexId = (WritableComparable)vertexIdIterator.next();
            owner = this.getServiceWorker().getVertexPartitionOwner(vertexId);
            workerInfo = owner.getWorkerInfo();
            currentMachineId = workerInfo.getTaskId();
            try {
                vertexId.write((DataOutput)this.idSerializer[currentMachineId]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialize the target vertex id.");
            }
            int n = currentMachineId;
            this.idCounter[n] = this.idCounter[n] + 1;
            if (this.idCounter[currentMachineId] != 1) continue;
            this.firstPartitionMap[currentMachineId] = owner.getPartitionId();
        }
        int idSerializerPos = 0;
        int workerMessageSize = 0;
        byte[] serializedId = null;
        WritableRequest writableRequest = null;
        for (int i = 0; i < this.idCounter.length; ++i) {
            if (this.idCounter[i] == 1) {
                serializedId = this.idSerializer[i].getByteArray();
                idSerializerPos = this.idSerializer[i].getPos();
                workerMessageSize = this.addMessage(this.workerInfoList[i], this.firstPartitionMap[i], serializedId, idSerializerPos, message);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("sendMessageToAllRequest: Send bytes (" + message.toString() + ") to one target in  worker " + this.workerInfoList[i]));
                }
                ++this.totalMsgsSentInSuperstep;
                if (workerMessageSize < this.maxMessagesSizePerWorker) continue;
                PairList workerMessages = this.removeWorkerMessages(this.workerInfoList[i]);
                writableRequest = new SendWorkerMessagesRequest(workerMessages);
                this.totalMsgBytesSentInSuperstep += (long)writableRequest.getSerializedSize();
                this.clientProcessor.doRequest(this.workerInfoList[i], writableRequest);
                this.getServiceWorker().getGraphTaskManager().notifySentMessages();
                continue;
            }
            if (this.idCounter[i] <= 1) continue;
            serializedId = this.idSerializer[i].getByteArray();
            idSerializerPos = this.idSerializer[i].getPos();
            workerMessageSize = this.addOneToManyMessage(this.workerInfoList[i], serializedId, idSerializerPos, this.idCounter[i], message);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("sendMessageToAllRequest: Send bytes (" + message.toString() + ") to all targets in worker" + this.workerInfoList[i]));
            }
            this.totalMsgsSentInSuperstep += (long)this.idCounter[i];
            if (workerMessageSize < this.maxMessagesSizePerWorker) continue;
            ByteArrayOneMessageToManyIds<I, M> workerMsgVids = this.removeWorkerMsgVids(this.workerInfoList[i]);
            writableRequest = new SendWorkerOneMessageToManyRequest<I, M>(workerMsgVids, this.getConf());
            this.totalMsgBytesSentInSuperstep += (long)writableRequest.getSerializedSize();
            this.clientProcessor.doRequest(this.workerInfoList[i], writableRequest);
            this.getServiceWorker().getGraphTaskManager().notifySentMessages();
        }
    }

    @Override
    public void flush() {
        super.flush();
        PairList<WorkerInfo, ByteArrayOneMessageToManyIds<I, M>> remainingMsgVidsCache = this.removeAllMsgVids();
        PairList.Iterator msgIdsIterator = remainingMsgVidsCache.getIterator();
        while (msgIdsIterator.hasNext()) {
            msgIdsIterator.next();
            SendWorkerOneMessageToManyRequest writableRequest = new SendWorkerOneMessageToManyRequest((ByteArrayOneMessageToManyIds)msgIdsIterator.getCurrentSecond(), this.getConf());
            this.totalMsgBytesSentInSuperstep += (long)((WritableRequest)writableRequest).getSerializedSize();
            this.clientProcessor.doRequest((WorkerInfo)msgIdsIterator.getCurrentFirst(), writableRequest);
        }
    }
}

