/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexMutations;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendMutationsCache<I extends WritableComparable, V extends Writable, E extends Writable> {
    private Map<Integer, Map<I, VertexMutations<I, V, E>>> mutationCache = new HashMap<Integer, Map<I, VertexMutations<I, V, E>>>();
    private final Map<Integer, Integer> mutationCountMap = new HashMap<Integer, Integer>();

    private VertexMutations<I, V, E> getVertexMutations(Integer partitionId, I destVertexId) {
        VertexMutations<I, V, E> mutations;
        Map<I, VertexMutations<I, VertexMutations<I, V, E>, E>> idMutations = this.mutationCache.get(partitionId);
        if (idMutations == null) {
            idMutations = new HashMap<I, VertexMutations<I, V, E>>();
            this.mutationCache.put(partitionId, idMutations);
        }
        if ((mutations = idMutations.get(destVertexId)) == null) {
            mutations = new VertexMutations();
            idMutations.put(destVertexId, mutations);
        }
        return mutations;
    }

    private int incrementPartitionMutationCount(int partitionId) {
        Integer currentPartitionMutationCount = this.mutationCountMap.get(partitionId);
        if (currentPartitionMutationCount == null) {
            currentPartitionMutationCount = 0;
        }
        Integer updatedPartitionMutationCount = currentPartitionMutationCount + 1;
        this.mutationCountMap.put(partitionId, updatedPartitionMutationCount);
        return updatedPartitionMutationCount;
    }

    public int addEdgeMutation(Integer partitionId, I destVertexId, Edge<I, E> edge) {
        VertexMutations<I, V, E> mutations = this.getVertexMutations(partitionId, destVertexId);
        mutations.addEdge(edge);
        return this.incrementPartitionMutationCount(partitionId);
    }

    public int removeEdgeMutation(Integer partitionId, I vertexIndex, I destinationVertexIndex) {
        VertexMutations<I, V, E> mutations = this.getVertexMutations(partitionId, vertexIndex);
        mutations.removeEdge(destinationVertexIndex);
        return this.incrementPartitionMutationCount(partitionId);
    }

    public int addVertexMutation(Integer partitionId, Vertex<I, V, E> vertex) {
        VertexMutations<I, V, E> mutations = this.getVertexMutations(partitionId, vertex.getId());
        mutations.addVertex(vertex);
        return this.incrementPartitionMutationCount(partitionId);
    }

    public int removeVertexMutation(Integer partitionId, I destVertexId) {
        VertexMutations<I, V, E> mutations = this.getVertexMutations(partitionId, destVertexId);
        mutations.removeVertex();
        return this.incrementPartitionMutationCount(partitionId);
    }

    public Map<I, VertexMutations<I, V, E>> removePartitionMutations(int partitionId) {
        Map<I, VertexMutations<I, V, E>> idMutations = this.mutationCache.remove(partitionId);
        this.mutationCountMap.put(partitionId, 0);
        return idMutations;
    }

    public Map<Integer, Map<I, VertexMutations<I, V, E>>> removeAllPartitionMutations() {
        Map<Integer, Map<I, VertexMutations<I, V, E>>> allMutations = this.mutationCache;
        this.mutationCache = new HashMap<Integer, Map<I, VertexMutations<I, V, E>>>();
        this.mutationCountMap.clear();
        return allMutations;
    }
}

