/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import java.util.Iterator;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendVertexIdDataCache;
import org.apache.giraph.comm.netty.NettyWorkerClientRequestProcessor;
import org.apache.giraph.comm.requests.SendWorkerMessagesRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SendMessageCache<I extends WritableComparable, M extends Writable>
extends SendVertexIdDataCache<I, M, VertexIdMessages<I, M>> {
    private static final Logger LOG = Logger.getLogger(SendMessageCache.class);
    protected long totalMsgsSentInSuperstep = 0L;
    protected long totalMsgBytesSentInSuperstep = 0L;
    protected final int maxMessagesSizePerWorker;
    protected final NettyWorkerClientRequestProcessor<I, ?, ?> clientProcessor;

    public SendMessageCache(ImmutableClassesGiraphConfiguration conf, CentralizedServiceWorker<?, ?, ?> serviceWorker, NettyWorkerClientRequestProcessor<I, ?, ?> processor, int maxMsgSize) {
        super(conf, serviceWorker, GiraphConstants.MAX_MSG_REQUEST_SIZE.get(conf), GiraphConstants.ADDITIONAL_MSG_REQUEST_SIZE.get(conf));
        this.maxMessagesSizePerWorker = maxMsgSize;
        this.clientProcessor = processor;
    }

    @Override
    public VertexIdMessages<I, M> createVertexIdData() {
        return new ByteArrayVertexIdMessages(this.getConf().getOutgoingMessageValueFactory());
    }

    public int addMessage(WorkerInfo workerInfo, int partitionId, I destVertexId, M message) {
        return this.addData(workerInfo, partitionId, destVertexId, message);
    }

    protected int addMessage(WorkerInfo workerInfo, int partitionId, byte[] serializedId, int idSerializerPos, M message) {
        return this.addData(workerInfo, partitionId, serializedId, idSerializerPos, message);
    }

    protected PairList<Integer, VertexIdMessages<I, M>> removeWorkerMessages(WorkerInfo workerInfo) {
        return this.removeWorkerData(workerInfo);
    }

    private PairList<WorkerInfo, PairList<Integer, VertexIdMessages<I, M>>> removeAllMessages() {
        return this.removeAllData();
    }

    public void sendMessageRequest(I destVertexId, M message) {
        PartitionOwner owner = this.getServiceWorker().getVertexPartitionOwner(destVertexId);
        WorkerInfo workerInfo = owner.getWorkerInfo();
        int partitionId = owner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("sendMessageRequest: Send bytes (" + message.toString() + ") to " + destVertexId + " on worker " + workerInfo));
        }
        ++this.totalMsgsSentInSuperstep;
        int workerMessageSize = this.addMessage(workerInfo, partitionId, destVertexId, message);
        if (workerMessageSize >= this.maxMessagesSizePerWorker) {
            PairList<Integer, VertexIdMessages<I, M>> workerMessages = this.removeWorkerMessages(workerInfo);
            SendWorkerMessagesRequest<I, M> writableRequest = new SendWorkerMessagesRequest<I, M>(workerMessages);
            this.totalMsgBytesSentInSuperstep += (long)((WritableRequest)writableRequest).getSerializedSize();
            this.clientProcessor.doRequest(workerInfo, writableRequest);
            this.getServiceWorker().getGraphTaskManager().notifySentMessages();
        }
    }

    public void sendMessageToAllRequest(Vertex<I, ?, ?> vertex, M message) {
        TargetVertexIdIterator targetVertexIterator = new TargetVertexIdIterator(vertex);
        this.sendMessageToAllRequest(targetVertexIterator, message);
    }

    public void sendMessageToAllRequest(Iterator<I> vertexIdIterator, M message) {
        while (vertexIdIterator.hasNext()) {
            this.sendMessageRequest((WritableComparable)vertexIdIterator.next(), message);
        }
    }

    public void flush() {
        PairList<WorkerInfo, PairList<Integer, VertexIdMessages<I, M>>> remainingMessageCache = this.removeAllMessages();
        PairList.Iterator iterator = remainingMessageCache.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            SendWorkerMessagesRequest writableRequest = new SendWorkerMessagesRequest((PairList)iterator.getCurrentSecond());
            this.totalMsgBytesSentInSuperstep += (long)((WritableRequest)writableRequest).getSerializedSize();
            this.clientProcessor.doRequest((WorkerInfo)iterator.getCurrentFirst(), writableRequest);
        }
    }

    public long resetMessageCount() {
        long messagesSentInSuperstep = this.totalMsgsSentInSuperstep;
        this.totalMsgsSentInSuperstep = 0L;
        return messagesSentInSuperstep;
    }

    public long resetMessageBytesCount() {
        long messageBytesSentInSuperstep = this.totalMsgBytesSentInSuperstep;
        this.totalMsgBytesSentInSuperstep = 0L;
        return messageBytesSentInSuperstep;
    }

    private class TargetVertexIdIterator
    implements Iterator<I> {
        private Iterator<Edge<I, Writable>> edgesIterator;

        private TargetVertexIdIterator(Vertex<I, ?, ?> vertex) {
            this.edgesIterator = vertex.getEdges().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.edgesIterator.hasNext();
        }

        @Override
        public I next() {
            return this.edgesIterator.next().getTargetVertexId();
        }

        @Override
        public void remove() {
        }
    }
}

