/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendVertexIdDataCache;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.utils.ByteArrayVertexIdEdges;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdEdges;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendEdgeCache<I extends WritableComparable, E extends Writable>
extends SendVertexIdDataCache<I, Edge<I, E>, VertexIdEdges<I, E>> {
    public SendEdgeCache(ImmutableClassesGiraphConfiguration conf, CentralizedServiceWorker<?, ?, ?> serviceWorker) {
        super(conf, serviceWorker, GiraphConstants.MAX_EDGE_REQUEST_SIZE.get(conf), GiraphConstants.ADDITIONAL_EDGE_REQUEST_SIZE.get(conf));
    }

    @Override
    public VertexIdEdges<I, E> createVertexIdData() {
        return new ByteArrayVertexIdEdges();
    }

    public int addEdge(WorkerInfo workerInfo, int partitionId, I destVertexId, Edge<I, E> edge) {
        return this.addData(workerInfo, partitionId, destVertexId, edge);
    }

    public PairList<Integer, VertexIdEdges<I, E>> removeWorkerEdges(WorkerInfo workerInfo) {
        return this.removeWorkerData(workerInfo);
    }

    public PairList<WorkerInfo, PairList<Integer, VertexIdEdges<I, E>>> removeAllEdges() {
        return this.removeAllData();
    }
}

