/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.worker.WorkerInfo;

@NotThreadSafe
public abstract class SendDataCache<D> {
    private final D[] dataCache;
    private final int[] initialBufferSizes;
    private final CentralizedServiceWorker serviceWorker;
    private final int[] dataSizes;
    private final int numWorkers;
    private final Map<WorkerInfo, List<Integer>> workerPartitions = Maps.newHashMap();
    private final ImmutableClassesGiraphConfiguration conf;

    public SendDataCache(ImmutableClassesGiraphConfiguration conf, CentralizedServiceWorker<?, ?, ?> serviceWorker, int maxRequestSize, float additionalRequestSize) {
        this.conf = conf;
        this.serviceWorker = serviceWorker;
        int maxPartition = 0;
        for (PartitionOwner partitionOwner : serviceWorker.getPartitionOwners()) {
            ArrayList workerPartitionIds = this.workerPartitions.get(partitionOwner.getWorkerInfo());
            if (workerPartitionIds == null) {
                workerPartitionIds = Lists.newArrayList();
                this.workerPartitions.put(partitionOwner.getWorkerInfo(), workerPartitionIds);
            }
            workerPartitionIds.add(partitionOwner.getPartitionId());
            maxPartition = Math.max(partitionOwner.getPartitionId(), maxPartition);
        }
        this.dataCache = new Object[maxPartition + 1];
        int maxWorker = 0;
        for (WorkerInfo workerInfo : serviceWorker.getWorkerInfoList()) {
            maxWorker = Math.max(maxWorker, workerInfo.getTaskId());
        }
        this.dataSizes = new int[maxWorker + 1];
        int initialRequestSize = (int)((float)maxRequestSize * (1.0f + additionalRequestSize));
        this.initialBufferSizes = new int[maxWorker + 1];
        for (WorkerInfo workerInfo : serviceWorker.getWorkerInfoList()) {
            this.initialBufferSizes[workerInfo.getTaskId()] = initialRequestSize / this.workerPartitions.get(workerInfo).size();
        }
        this.numWorkers = maxWorker + 1;
    }

    public PairList<Integer, D> removeWorkerData(WorkerInfo workerInfo) {
        PairList<Integer, D> workerData = new PairList<Integer, D>();
        List<Integer> partitions = this.workerPartitions.get(workerInfo);
        workerData.initialize(partitions.size());
        for (Integer partitionId : partitions) {
            if (this.dataCache[partitionId] == null) continue;
            workerData.add(partitionId, this.dataCache[partitionId]);
            this.dataCache[partitionId.intValue()] = null;
        }
        this.dataSizes[workerInfo.getTaskId()] = 0;
        return workerData;
    }

    public PairList<WorkerInfo, PairList<Integer, D>> removeAllData() {
        PairList<WorkerInfo, PairList<Integer, D>> allData = new PairList<WorkerInfo, PairList<Integer, D>>();
        allData.initialize(this.dataSizes.length);
        for (WorkerInfo workerInfo : this.workerPartitions.keySet()) {
            PairList<Integer, D> workerData = this.removeWorkerData(workerInfo);
            if (!workerData.isEmpty()) {
                allData.add(workerInfo, workerData);
            }
            this.dataSizes[workerInfo.getTaskId()] = 0;
        }
        return allData;
    }

    public D getData(int partitionId) {
        return this.dataCache[partitionId];
    }

    public void setData(int partitionId, D data) {
        this.dataCache[partitionId] = data;
    }

    public int getInitialBufferSize(int partitionId) {
        return this.initialBufferSizes[partitionId];
    }

    public int incrDataSize(int partitionId, int size) {
        int n = partitionId;
        this.dataSizes[n] = this.dataSizes[n] + size;
        return this.dataSizes[partitionId];
    }

    public ImmutableClassesGiraphConfiguration getConf() {
        return this.conf;
    }

    protected CentralizedServiceWorker getServiceWorker() {
        return this.serviceWorker;
    }

    protected int getSendWorkerInitialBufferSize(int taskId) {
        return this.initialBufferSizes[taskId];
    }

    protected int getNumWorkers() {
        return this.numWorkers;
    }

    protected Map<WorkerInfo, List<Integer>> getWorkerPartitions() {
        return this.workerPartitions;
    }
}

