/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.bsp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.giraph.bsp.CentralizedService;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.giraph.graph.InputSplitEvents;
import org.apache.giraph.graph.InputSplitPaths;
import org.apache.giraph.job.JobProgressTracker;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.utils.CheckpointingUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.giraph.zk.BspEvent;
import org.apache.giraph.zk.PredicateLock;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.giraph.zk.ZooKeeperManager;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BspService<I extends WritableComparable, V extends Writable, E extends Writable>
implements Watcher,
CentralizedService<I, V, E> {
    public static final long UNSET_SUPERSTEP = Long.MIN_VALUE;
    public static final long INPUT_SUPERSTEP = -1L;
    public static final long UNSET_APPLICATION_ATTEMPT = Long.MIN_VALUE;
    public static final String BASE_DIR = "/_hadoopBsp";
    public static final String MASTER_JOB_STATE_NODE = "/_masterJobState";
    public static final String MAPPING_INPUT_SPLIT_DIR = "/_mappingInputSplitDir";
    public static final String MAPPING_INPUT_SPLIT_DONE_DIR = "/_mappingInputSplitDoneDir";
    public static final String MAPPING_INPUT_SPLIT_RESERVED_NODE = "/_mappingInputSplitReserved";
    public static final String MAPPING_INPUT_SPLIT_FINISHED_NODE = "/_mappingInputSplitFinished";
    public static final String MAPPING_INPUT_SPLITS_ALL_READY_NODE = "/_mappingInputSplitsAllReady";
    public static final String MAPPING_INPUT_SPLITS_ALL_DONE_NODE = "/_mappingInputSplitsAllDone";
    public static final String VERTEX_INPUT_SPLIT_DIR = "/_vertexInputSplitDir";
    public static final String VERTEX_INPUT_SPLIT_DONE_DIR = "/_vertexInputSplitDoneDir";
    public static final String VERTEX_INPUT_SPLIT_RESERVED_NODE = "/_vertexInputSplitReserved";
    public static final String VERTEX_INPUT_SPLIT_FINISHED_NODE = "/_vertexInputSplitFinished";
    public static final String VERTEX_INPUT_SPLITS_ALL_READY_NODE = "/_vertexInputSplitsAllReady";
    public static final String VERTEX_INPUT_SPLITS_ALL_DONE_NODE = "/_vertexInputSplitsAllDone";
    public static final String EDGE_INPUT_SPLIT_DIR = "/_edgeInputSplitDir";
    public static final String EDGE_INPUT_SPLIT_DONE_DIR = "/_edgeInputSplitDoneDir";
    public static final String EDGE_INPUT_SPLIT_RESERVED_NODE = "/_edgeInputSplitReserved";
    public static final String EDGE_INPUT_SPLIT_FINISHED_NODE = "/_edgeInputSplitFinished";
    public static final String EDGE_INPUT_SPLITS_ALL_READY_NODE = "/_edgeInputSplitsAllReady";
    public static final String EDGE_INPUT_SPLITS_ALL_DONE_NODE = "/_edgeInputSplitsAllDone";
    public static final String APPLICATION_ATTEMPTS_DIR = "/_applicationAttemptsDir";
    public static final String MASTER_ELECTION_DIR = "/_masterElectionDir";
    public static final String SUPERSTEP_DIR = "/_superstepDir";
    public static final String MERGED_AGGREGATOR_DIR = "/_mergedAggregatorDir";
    public static final String WORKER_HEALTHY_DIR = "/_workerHealthyDir";
    public static final String WORKER_UNHEALTHY_DIR = "/_workerUnhealthyDir";
    public static final String WORKER_WROTE_CHECKPOINT_DIR = "/_workerWroteCheckpointDir";
    public static final String WORKER_FINISHED_DIR = "/_workerFinishedDir";
    public static final String ADDRESSES_AND_PARTITIONS_DIR = "/_addressesAndPartitions";
    public static final String PARTITION_EXCHANGE_DIR = "/_partitionExchangeDir";
    public static final String SUPERSTEP_FINISHED_NODE = "/_superstepFinished";
    public static final String HALT_COMPUTATION_NODE = "/_haltComputation";
    public static final String FORCE_CHECKPOINT_USER_FLAG = "/_checkpointAndStop";
    public static final String CLEANED_UP_DIR = "/_cleanedUpDir";
    public static final String JSONOBJ_PARTITION_STATS_KEY = "_partitionStatsKey";
    public static final String JSONOBJ_NUM_MESSAGES_KEY = "_numMsgsKey";
    public static final String JSONOBJ_NUM_MESSAGE_BYTES_KEY = "_numMsgBytesKey";
    public static final String JSONOBJ_METRICS_KEY = "_metricsKey";
    public static final String JSONOBJ_STATE_KEY = "_stateKey";
    public static final String JSONOBJ_APPLICATION_ATTEMPT_KEY = "_applicationAttemptKey";
    public static final String JSONOBJ_SUPERSTEP_KEY = "_superstepKey";
    public static final String WORKER_SUFFIX = "_worker";
    public static final String MASTER_SUFFIX = "_master";
    private static final Logger LOG = Logger.getLogger(BspService.class);
    protected final String basePath;
    protected final String masterJobStatePath;
    protected final InputSplitPaths mappingInputSplitsPaths;
    protected final InputSplitPaths vertexInputSplitsPaths;
    protected final InputSplitPaths edgeInputSplitsPaths;
    protected final InputSplitEvents mappingInputSplitsEvents;
    protected final InputSplitEvents vertexInputSplitsEvents;
    protected final InputSplitEvents edgeInputSplitsEvents;
    protected final String applicationAttemptsPath;
    protected final String cleanedUpPath;
    protected final String checkpointBasePath;
    protected final String savedCheckpointBasePath;
    protected final String masterElectionPath;
    protected final String haltComputationPath;
    private final ZooKeeperExt zk;
    private final BspEvent connectedEvent;
    private final BspEvent workerHealthRegistrationChanged;
    private final BspEvent addressesAndPartitionsReadyChanged;
    private final BspEvent applicationAttemptChanged;
    private final BspEvent superstepFinished;
    private final BspEvent masterElectionChildrenChanged;
    private final BspEvent cleanedUpChildrenChanged;
    private final List<BspEvent> registeredBspEvents = new ArrayList<BspEvent>();
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private final Mapper.Context context;
    private long cachedSuperstep = Long.MIN_VALUE;
    private long restartedSuperstep = Long.MIN_VALUE;
    private long cachedApplicationAttempt = Long.MIN_VALUE;
    private final String jobId;
    private final int taskPartition;
    private final String hostname;
    private final String hostnamePartitionId;
    private final GraphPartitionerFactory<I, V, E> graphPartitionerFactory;
    private final GraphTaskManager<I, V, E> graphTaskManager;
    private final FileSystem fs;

    public BspService(Mapper.Context context, GraphTaskManager<I, V, E> graphTaskManager) {
        this.mappingInputSplitsEvents = new InputSplitEvents((Progressable)context);
        this.vertexInputSplitsEvents = new InputSplitEvents((Progressable)context);
        this.edgeInputSplitsEvents = new InputSplitEvents((Progressable)context);
        this.connectedEvent = new PredicateLock((Progressable)context);
        this.workerHealthRegistrationChanged = new PredicateLock((Progressable)context);
        this.addressesAndPartitionsReadyChanged = new PredicateLock((Progressable)context);
        this.applicationAttemptChanged = new PredicateLock((Progressable)context);
        this.superstepFinished = new PredicateLock((Progressable)context);
        this.masterElectionChildrenChanged = new PredicateLock((Progressable)context);
        this.cleanedUpChildrenChanged = new PredicateLock((Progressable)context);
        this.registerBspEvent(this.connectedEvent);
        this.registerBspEvent(this.workerHealthRegistrationChanged);
        this.registerBspEvent(this.vertexInputSplitsEvents.getAllReadyChanged());
        this.registerBspEvent(this.vertexInputSplitsEvents.getStateChanged());
        this.registerBspEvent(this.edgeInputSplitsEvents.getAllReadyChanged());
        this.registerBspEvent(this.edgeInputSplitsEvents.getStateChanged());
        this.registerBspEvent(this.addressesAndPartitionsReadyChanged);
        this.registerBspEvent(this.applicationAttemptChanged);
        this.registerBspEvent(this.superstepFinished);
        this.registerBspEvent(this.masterElectionChildrenChanged);
        this.registerBspEvent(this.cleanedUpChildrenChanged);
        this.context = context;
        this.graphTaskManager = graphTaskManager;
        this.conf = graphTaskManager.getConf();
        this.jobId = this.conf.get("mapred.job.id", "Unknown Job");
        this.taskPartition = this.conf.getTaskPartition();
        this.restartedSuperstep = this.conf.getLong("giraph.restartSuperstep", Long.MIN_VALUE);
        try {
            this.hostname = this.conf.getLocalHostname();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.hostnamePartitionId = this.hostname + "_" + this.getTaskPartition();
        this.graphPartitionerFactory = this.conf.createGraphPartitioner();
        this.basePath = ZooKeeperManager.getBasePath(this.conf) + BASE_DIR + "/" + this.jobId;
        this.getContext().getCounter("Zookeeper base path", this.basePath);
        this.masterJobStatePath = this.basePath + MASTER_JOB_STATE_NODE;
        this.mappingInputSplitsPaths = new InputSplitPaths(this.basePath, MAPPING_INPUT_SPLIT_DIR, MAPPING_INPUT_SPLIT_DONE_DIR, MAPPING_INPUT_SPLITS_ALL_READY_NODE, MAPPING_INPUT_SPLITS_ALL_DONE_NODE);
        this.vertexInputSplitsPaths = new InputSplitPaths(this.basePath, VERTEX_INPUT_SPLIT_DIR, VERTEX_INPUT_SPLIT_DONE_DIR, VERTEX_INPUT_SPLITS_ALL_READY_NODE, VERTEX_INPUT_SPLITS_ALL_DONE_NODE);
        this.edgeInputSplitsPaths = new InputSplitPaths(this.basePath, EDGE_INPUT_SPLIT_DIR, EDGE_INPUT_SPLIT_DONE_DIR, EDGE_INPUT_SPLITS_ALL_READY_NODE, EDGE_INPUT_SPLITS_ALL_DONE_NODE);
        this.applicationAttemptsPath = this.basePath + APPLICATION_ATTEMPTS_DIR;
        this.cleanedUpPath = this.basePath + CLEANED_UP_DIR;
        String restartJobId = GiraphConstants.RESTART_JOB_ID.get(this.conf);
        this.savedCheckpointBasePath = CheckpointingUtils.getCheckpointBasePath(this.getConfiguration(), restartJobId == null ? this.getJobId() : restartJobId);
        this.checkpointBasePath = CheckpointingUtils.getCheckpointBasePath(this.getConfiguration(), this.getJobId());
        this.masterElectionPath = this.basePath + MASTER_ELECTION_DIR;
        String serverPortList = this.conf.getZookeeperList();
        this.haltComputationPath = this.basePath + HALT_COMPUTATION_NODE;
        this.getContext().getCounter("Zookeeper halt node", this.haltComputationPath);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("BspService: Path to create to halt is " + this.haltComputationPath));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("BspService: Connecting to ZooKeeper with job " + this.jobId + ", " + this.getTaskPartition() + " on " + serverPortList));
        }
        try {
            this.zk = new ZooKeeperExt(serverPortList, this.conf.getZooKeeperSessionTimeout(), this.conf.getZookeeperOpsMaxAttempts(), this.conf.getZookeeperOpsRetryWaitMsecs(), this, (Progressable)context);
            this.connectedEvent.waitForever();
            this.fs = FileSystem.get(this.getConfiguration());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (restartJobId != null && this.restartedSuperstep == Long.MIN_VALUE) {
            try {
                this.restartedSuperstep = this.getLastCheckpointedSuperstep();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.cachedSuperstep = this.restartedSuperstep;
        if (this.restartedSuperstep != Long.MIN_VALUE && this.restartedSuperstep < 0L) {
            throw new IllegalArgumentException("BspService: Invalid superstep to restart - " + this.restartedSuperstep);
        }
    }

    public static long getSuperstepFromPath(String path) {
        int endIndex;
        int foundSuperstepStart = path.indexOf(SUPERSTEP_DIR);
        if (foundSuperstepStart == -1) {
            throw new IllegalArgumentException("getSuperstepFromPath: Cannot find /_superstepDirfrom " + path);
        }
        if ((endIndex = (foundSuperstepStart += SUPERSTEP_DIR.length() + 1) + path.substring(foundSuperstepStart).indexOf("/")) == -1) {
            throw new IllegalArgumentException("getSuperstepFromPath: Cannot find end of superstep from " + path);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("getSuperstepFromPath: Got path=" + path + ", start=" + foundSuperstepStart + ", end=" + endIndex));
        }
        return Long.parseLong(path.substring(foundSuperstepStart, endIndex));
    }

    public static String getHealthyHostnameIdFromPath(String path) {
        int foundWorkerHealthyStart = path.indexOf(WORKER_HEALTHY_DIR);
        if (foundWorkerHealthyStart == -1) {
            throw new IllegalArgumentException("getHealthyHostnameidFromPath: Couldn't find /_workerHealthyDir from " + path);
        }
        return path.substring(foundWorkerHealthyStart += WORKER_HEALTHY_DIR.length());
    }

    public final String getSuperstepPath(long attempt) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR;
    }

    public InputSplitEvents getEdgeInputSplitsEvents() {
        return this.edgeInputSplitsEvents;
    }

    public InputSplitEvents getVertexInputSplitsEvents() {
        return this.vertexInputSplitsEvents;
    }

    public final String getWorkerInfoHealthyPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + WORKER_HEALTHY_DIR;
    }

    public final String getWorkerInfoUnhealthyPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + WORKER_UNHEALTHY_DIR;
    }

    public final String getWorkerWroteCheckpointPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + WORKER_WROTE_CHECKPOINT_DIR;
    }

    public final String getWorkerFinishedPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + WORKER_FINISHED_DIR;
    }

    public final String getAddressesAndPartitionsPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + ADDRESSES_AND_PARTITIONS_DIR;
    }

    public final String getPartitionExchangePath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + PARTITION_EXCHANGE_DIR;
    }

    public final String getPartitionExchangeWorkerPath(long attempt, long superstep, WorkerInfo workerInfo) {
        return this.getPartitionExchangePath(attempt, superstep) + "/" + workerInfo.getHostnameId();
    }

    public final String getSuperstepFinishedPath(long attempt, long superstep) {
        return this.applicationAttemptsPath + "/" + attempt + SUPERSTEP_DIR + "/" + superstep + SUPERSTEP_FINISHED_NODE;
    }

    public final String getCheckpointBasePath(long superstep) {
        return this.checkpointBasePath + "/" + superstep;
    }

    public final String getSavedCheckpointBasePath(long superstep) {
        return this.savedCheckpointBasePath + "/" + superstep;
    }

    public final ZooKeeperExt getZkExt() {
        return this.zk;
    }

    @Override
    public final long getRestartedSuperstep() {
        return this.restartedSuperstep;
    }

    public final void setRestartedSuperstep(long superstep) {
        if (superstep < -1L) {
            throw new IllegalArgumentException("setRestartedSuperstep: Bad argument " + superstep);
        }
        this.restartedSuperstep = superstep;
    }

    public final FileSystem getFs() {
        return this.fs;
    }

    public final ImmutableClassesGiraphConfiguration<I, V, E> getConfiguration() {
        return this.conf;
    }

    public final Mapper.Context getContext() {
        return this.context;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final String getHostnamePartitionId() {
        return this.hostnamePartitionId;
    }

    public final int getTaskPartition() {
        return this.taskPartition;
    }

    public final GraphTaskManager<I, V, E> getGraphTaskManager() {
        return this.graphTaskManager;
    }

    public final BspEvent getWorkerHealthRegistrationChangedEvent() {
        return this.workerHealthRegistrationChanged;
    }

    public final BspEvent getAddressesAndPartitionsReadyChangedEvent() {
        return this.addressesAndPartitionsReadyChanged;
    }

    public final BspEvent getApplicationAttemptChangedEvent() {
        return this.applicationAttemptChanged;
    }

    public final BspEvent getSuperstepFinishedEvent() {
        return this.superstepFinished;
    }

    public final BspEvent getMasterElectionChildrenChangedEvent() {
        return this.masterElectionChildrenChanged;
    }

    public final BspEvent getCleanedUpChildrenChangedEvent() {
        return this.cleanedUpChildrenChanged;
    }

    public final JSONObject getJobState() {
        try {
            this.getZkExt().createExt(this.masterJobStatePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.info((Object)("getJobState: Job state already exists (" + this.masterJobStatePath + ")"));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Failed to create job state path due to KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to create job state path due to InterruptedException", e);
        }
        String jobState = null;
        try {
            List<String> childList = this.getZkExt().getChildrenExt(this.masterJobStatePath, true, true, true);
            if (childList.isEmpty()) {
                return null;
            }
            jobState = new String(this.getZkExt().getData(childList.get(childList.size() - 1), true, null), Charset.defaultCharset());
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("getJobState: Job state path is empty! - " + this.masterJobStatePath));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Failed to get job state path children due to KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to get job state path children due to InterruptedException", e);
        }
        try {
            return new JSONObject(jobState);
        }
        catch (JSONException e) {
            throw new RuntimeException("getJobState: Failed to parse job state " + jobState);
        }
    }

    public final String getJobId() {
        return this.jobId;
    }

    public final long getApplicationAttempt() {
        if (this.cachedApplicationAttempt != Long.MIN_VALUE) {
            return this.cachedApplicationAttempt;
        }
        try {
            this.getZkExt().createExt(this.applicationAttemptsPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.info((Object)("getApplicationAttempt: Node " + this.applicationAttemptsPath + " already exists!"));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Couldn't create application attempts path due to KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Couldn't create application attempts path due to InterruptedException", e);
        }
        try {
            List<String> attemptList = this.getZkExt().getChildrenExt(this.applicationAttemptsPath, true, false, false);
            this.cachedApplicationAttempt = attemptList.isEmpty() ? 0L : Long.parseLong(Collections.max(attemptList));
        }
        catch (KeeperException e) {
            throw new IllegalStateException("Couldn't get application attempts to KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Couldn't get application attempts to InterruptedException", e);
        }
        return this.cachedApplicationAttempt;
    }

    @Override
    public final long getSuperstep() {
        List<String> superstepList;
        if (this.cachedSuperstep != Long.MIN_VALUE) {
            return this.cachedSuperstep;
        }
        String superstepPath = this.getSuperstepPath(this.getApplicationAttempt());
        try {
            this.getZkExt().createExt(superstepPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("getApplicationAttempt: Node " + this.applicationAttemptsPath + " already exists!"));
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getSuperstep: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getSuperstep: InterruptedException", e);
        }
        try {
            superstepList = this.getZkExt().getChildrenExt(superstepPath, true, false, false);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getSuperstep: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getSuperstep: InterruptedException", e);
        }
        this.cachedSuperstep = superstepList.isEmpty() ? -1L : Long.parseLong(Collections.max(superstepList));
        return this.cachedSuperstep;
    }

    public final void incrCachedSuperstep() {
        if (this.cachedSuperstep == Long.MIN_VALUE) {
            throw new IllegalStateException("incrSuperstep: Invalid unset cached superstep -9223372036854775808");
        }
        ++this.cachedSuperstep;
    }

    public final void setCachedSuperstep(long superstep) {
        this.cachedSuperstep = superstep;
    }

    public final void setApplicationAttempt(long applicationAttempt) {
        this.cachedApplicationAttempt = applicationAttempt;
        String superstepPath = this.getSuperstepPath(this.cachedApplicationAttempt);
        try {
            this.getZkExt().createExt(superstepPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            throw new IllegalArgumentException("setApplicationAttempt: Attempt already exists! - " + superstepPath, e);
        }
        catch (KeeperException e) {
            throw new RuntimeException("setApplicationAttempt: KeeperException - " + superstepPath, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("setApplicationAttempt: InterruptedException - " + superstepPath, e);
        }
    }

    public void registerBspEvent(BspEvent event) {
        this.registeredBspEvents.add(event);
    }

    protected GraphPartitionerFactory<I, V, E> getGraphPartitionerFactory() {
        return this.graphPartitionerFactory;
    }

    protected boolean processEvent(WatchedEvent event) {
        return false;
    }

    public final void process(WatchedEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("process: Got a new event, path = " + event.getPath() + ", type = " + event.getType() + ", state = " + event.getState()));
        }
        if (event.getPath() == null && event.getType() == Watcher.Event.EventType.None) {
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                for (BspEvent bspEvent : this.registeredBspEvents) {
                    bspEvent.signal();
                }
                LOG.warn((Object)("process: Disconnected from ZooKeeper (will automatically try to recover) " + event));
            } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: Asynchronous connection complete.");
                }
                this.connectedEvent.signal();
            } else {
                LOG.warn((Object)("process: Got unknown null path event " + event));
            }
            return;
        }
        boolean eventProcessed = false;
        if (event.getPath().startsWith(this.masterJobStatePath)) {
            this.masterElectionChildrenChanged.signal();
            eventProcessed = true;
        } else if ((event.getPath().contains(WORKER_HEALTHY_DIR) || event.getPath().contains(WORKER_UNHEALTHY_DIR)) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: workerHealthRegistrationChanged (worker health reported - healthy/unhealthy )");
            }
            this.workerHealthRegistrationChanged.signal();
            eventProcessed = true;
        } else {
            if (this.processMappingEvent(event) || this.processVertexEvent(event) || this.processEdgeEvent(event)) {
                return;
            }
            if (event.getPath().contains(ADDRESSES_AND_PARTITIONS_DIR) && event.getType() == Watcher.Event.EventType.NodeCreated) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: partitionAssignmentsReadyChanged (partitions are assigned)");
                }
                this.addressesAndPartitionsReadyChanged.signal();
                eventProcessed = true;
            } else if (event.getPath().contains(SUPERSTEP_FINISHED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: superstepFinished signaled");
                }
                this.superstepFinished.signal();
                eventProcessed = true;
            } else if (event.getPath().endsWith(this.applicationAttemptsPath) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: applicationAttemptChanged signaled");
                }
                this.applicationAttemptChanged.signal();
                eventProcessed = true;
            } else if (event.getPath().contains(MASTER_ELECTION_DIR) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: masterElectionChildrenChanged signaled");
                }
                this.masterElectionChildrenChanged.signal();
                eventProcessed = true;
            } else if (event.getPath().equals(this.cleanedUpPath) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"process: cleanedUpChildrenChanged signaled");
                }
                this.cleanedUpChildrenChanged.signal();
                eventProcessed = true;
            }
        }
        if (!this.processEvent(event) && !eventProcessed) {
            LOG.warn((Object)("process: Unknown and unprocessed event (path=" + event.getPath() + ", type=" + event.getType() + ", state=" + event.getState() + ")"));
        }
    }

    public final boolean processMappingEvent(WatchedEvent event) {
        boolean eventProcessed = false;
        if (event.getPath().equals(this.mappingInputSplitsPaths.getAllReadyPath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: inputSplitsReadyChanged (input splits ready)");
            }
            this.mappingInputSplitsEvents.getAllReadyChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(MAPPING_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: mappingInputSplitsStateChanged (made a reservation)");
            }
            this.mappingInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(MAPPING_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: mappingInputSplitsStateChanged (lost a reservation)");
            }
            this.mappingInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(MAPPING_INPUT_SPLIT_FINISHED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: mappingInputSplitsStateChanged (finished inputsplit)");
            }
            this.mappingInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(MAPPING_INPUT_SPLIT_DONE_DIR) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: mappingInputSplitsDoneStateChanged (worker finished sending)");
            }
            this.mappingInputSplitsEvents.getDoneStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().equals(this.mappingInputSplitsPaths.getAllDonePath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: mappingInputSplitsAllDoneChanged (all entries sent from input splits)");
            }
            this.mappingInputSplitsEvents.getAllDoneChanged().signal();
            eventProcessed = true;
        }
        return eventProcessed;
    }

    public final boolean processVertexEvent(WatchedEvent event) {
        boolean eventProcessed = false;
        if (event.getPath().equals(this.vertexInputSplitsPaths.getAllReadyPath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: inputSplitsReadyChanged (input splits ready)");
            }
            this.vertexInputSplitsEvents.getAllReadyChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(VERTEX_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: vertexInputSplitsStateChanged (made a reservation)");
            }
            this.vertexInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(VERTEX_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: vertexInputSplitsStateChanged (lost a reservation)");
            }
            this.vertexInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(VERTEX_INPUT_SPLIT_FINISHED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: vertexInputSplitsStateChanged (finished inputsplit)");
            }
            this.vertexInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(VERTEX_INPUT_SPLIT_DONE_DIR) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: vertexInputSplitsDoneStateChanged (worker finished sending)");
            }
            this.vertexInputSplitsEvents.getDoneStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().equals(this.vertexInputSplitsPaths.getAllDonePath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: vertexInputSplitsAllDoneChanged (all vertices sent from input splits)");
            }
            this.vertexInputSplitsEvents.getAllDoneChanged().signal();
            eventProcessed = true;
        }
        return eventProcessed;
    }

    public final boolean processEdgeEvent(WatchedEvent event) {
        boolean eventProcessed = false;
        if (event.getPath().equals(this.edgeInputSplitsPaths.getAllReadyPath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: edgeInputSplitsReadyChanged (input splits ready)");
            }
            this.edgeInputSplitsEvents.getAllReadyChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(EDGE_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: edgeInputSplitsStateChanged (made a reservation)");
            }
            this.edgeInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(EDGE_INPUT_SPLIT_RESERVED_NODE) && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: edgeInputSplitsStateChanged (lost a reservation)");
            }
            this.edgeInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(EDGE_INPUT_SPLIT_FINISHED_NODE) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: edgeInputSplitsStateChanged (finished inputsplit)");
            }
            this.edgeInputSplitsEvents.getStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().endsWith(EDGE_INPUT_SPLIT_DONE_DIR) && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"process: edgeInputSplitsDoneStateChanged (worker finished sending)");
            }
            this.edgeInputSplitsEvents.getDoneStateChanged().signal();
            eventProcessed = true;
        } else if (event.getPath().equals(this.edgeInputSplitsPaths.getAllDonePath()) && event.getType() == Watcher.Event.EventType.NodeCreated) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"process: edgeInputSplitsAllDoneChanged (all edges sent from input splits)");
            }
            this.edgeInputSplitsEvents.getAllDoneChanged().signal();
            eventProcessed = true;
        }
        return eventProcessed;
    }

    protected long getLastCheckpointedSuperstep() throws IOException {
        return CheckpointingUtils.getLastCheckpointedSuperstep(this.getFs(), this.savedCheckpointBasePath);
    }

    @Override
    public JobProgressTracker getJobProgressTracker() {
        return this.getGraphTaskManager().getJobProgressTracker();
    }
}

