/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.bsp;

import java.io.IOException;
import org.apache.giraph.bsp.BspRecordWriter;
import org.apache.giraph.bsp.ImmutableOutputCommitter;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class BspOutputFormat
extends OutputFormat<Text, Text> {
    private static Logger LOG = Logger.getLogger(BspOutputFormat.class);

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        ImmutableClassesGiraphConfiguration conf = new ImmutableClassesGiraphConfiguration(context.getConfiguration());
        if (!conf.hasVertexOutputFormat() && !conf.hasEdgeOutputFormat()) {
            LOG.warn((Object)"checkOutputSpecs: ImmutableOutputCommiter will not check anything");
            return;
        }
        if (conf.hasVertexOutputFormat()) {
            conf.createWrappedVertexOutputFormat().checkOutputSpecs(context);
        }
        if (conf.hasEdgeOutputFormat()) {
            conf.createWrappedEdgeOutputFormat().checkOutputSpecs(context);
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        ImmutableClassesGiraphConfiguration conf = new ImmutableClassesGiraphConfiguration(context.getConfiguration());
        if (!conf.hasVertexOutputFormat() && !conf.hasEdgeOutputFormat()) {
            LOG.warn((Object)"getOutputCommitter: Returning ImmutableOutputCommiter (does nothing).");
            return new ImmutableOutputCommitter();
        }
        if (conf.hasVertexOutputFormat()) {
            return conf.createWrappedVertexOutputFormat().getOutputCommitter(context);
        }
        return conf.createWrappedEdgeOutputFormat().getOutputCommitter(context);
    }

    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new BspRecordWriter();
    }
}

