/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.bsp;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class BspInputSplit
extends InputSplit
implements Writable {
    private int numSplits = -1;
    private int splitIndex = -1;

    public BspInputSplit() {
    }

    public BspInputSplit(int splitIndex, int numSplits) {
        this.splitIndex = splitIndex;
        this.numSplits = numSplits;
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void readFields(DataInput in) throws IOException {
        this.splitIndex = in.readInt();
        this.numSplits = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitIndex);
        out.writeInt(this.numSplits);
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public String toString() {
        return "'" + ((Object)((Object)this)).getClass().getCanonicalName() + ", index=" + this.getSplitIndex() + ", num=" + this.getNumSplits();
    }
}

