/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.bsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.bsp.BspRecordReader;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class BspInputFormat
extends InputFormat<Text, Text> {
    private static final Logger LOG = Logger.getLogger(BspInputFormat.class);

    public static int getMaxTasks(Configuration conf) {
        int maxWorkers = conf.getInt("giraph.maxWorkers", 0);
        boolean splitMasterWorker = GiraphConstants.SPLIT_MASTER_WORKER.get(conf);
        int maxTasks = maxWorkers;
        boolean isYarnJob = GiraphConstants.IS_PURE_YARN_JOB.get(conf);
        if (splitMasterWorker && !isYarnJob) {
            int zkServers = GiraphConstants.ZOOKEEPER_SERVER_COUNT.get(conf);
            maxTasks += zkServers;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getMaxTasks: Max workers = " + maxWorkers + ", split master/worker = " + splitMasterWorker + ", is YARN-only job = " + isYarnJob + ", total max tasks = " + maxTasks));
        }
        return maxTasks;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        int maxTasks = BspInputFormat.getMaxTasks(conf);
        if (maxTasks <= 0) {
            throw new InterruptedException("getSplits: Cannot have maxTasks <= 0 - " + maxTasks);
        }
        ArrayList<InputSplit> inputSplitList = new ArrayList<InputSplit>();
        for (int i = 0; i < maxTasks; ++i) {
            inputSplitList.add(new BspInputSplit());
        }
        return inputSplitList;
    }

    public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new BspRecordReader();
    }
}

