/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

public class WeightedPageRankComputation
extends BasicComputation<LongWritable, DoubleWritable, DoubleWritable, DoubleWritable> {
    public static final String SUPERSTEP_COUNT = "giraph.weightedPageRank.superstepCount";

    @Override
    public void compute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() == 0L) {
            double outEdgeSum = 0.0;
            for (Edge edge : vertex.getEdges()) {
                outEdgeSum += ((DoubleWritable)edge.getValue()).get();
            }
            for (MutableEdge mutableEdge : vertex.getMutableEdges()) {
                mutableEdge.setValue(new DoubleWritable(((DoubleWritable)mutableEdge.getValue()).get() / outEdgeSum));
            }
        } else {
            double messageSum = 0.0;
            for (DoubleWritable doubleWritable : messages) {
                messageSum += doubleWritable.get();
            }
            vertex.getValue().set((double)(0.15f / (float)this.getTotalNumVertices()) + (double)0.85f * messageSum);
        }
        if (this.getSuperstep() < (long)this.getConf().getInt(SUPERSTEP_COUNT, 0)) {
            for (Edge<LongWritable, DoubleWritable> edge : vertex.getEdges()) {
                this.sendMessage(edge.getTargetVertexId(), new DoubleWritable(vertex.getValue().get() * edge.getValue().get()));
            }
        } else {
            vertex.voteToHalt();
        }
    }
}

