/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.benchmark.WeightedPageRankComputation;
import org.apache.giraph.combiner.DoubleSumMessageCombiner;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.HashMapEdges;
import org.apache.giraph.edge.LongDoubleArrayEdges;
import org.apache.giraph.io.formats.JsonBase64VertexOutputFormat;
import org.apache.giraph.io.formats.PseudoRandomEdgeInputFormat;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.giraph.partition.SimpleLongRangePartitionerFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class WeightedPageRankBenchmark
extends GiraphBenchmark {
    private static final Logger LOG = Logger.getLogger(WeightedPageRankBenchmark.class);
    private static final BenchmarkOption EDGES_CLASS = new BenchmarkOption("c", "edgesClass", true, "Vertex edges class (0 for LongDoubleArrayEdges,1 for ByteArrayEdges, 2 for ByteArrayEdges with unsafe serialization, 3 for ArrayListEdges, 4 for HashMapVertex");
    private static final BenchmarkOption EDGE_INPUT = new BenchmarkOption("ei", "edgeInput", false, "Use edge-based input instead of vertex-based input.");
    private static final BenchmarkOption PARTITIONER = new BenchmarkOption("p", "partitioner", true, "Partitioning algorithm (0 for hash partitioning (default), 1 for range partitioning)");
    private static final BenchmarkOption MESSAGE_COMBINER_TYPE = new BenchmarkOption("t", "combinerType", true, "MessageCombiner type (0 for no combiner, 1 for DoubleSumMessageCombiner (default)");
    private static final BenchmarkOption OUTPUT_FORMAT = new BenchmarkOption("o", "vertexOutputFormat", true, "0 for JsonBase64VertexOutputFormat");

    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.SUPERSTEPS, BenchmarkOption.VERTICES, BenchmarkOption.EDGES_PER_VERTEX, BenchmarkOption.LOCAL_EDGES_MIN_RATIO, EDGES_CLASS, EDGE_INPUT, PARTITIONER, MESSAGE_COMBINER_TYPE, OUTPUT_FORMAT});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration configuration, CommandLine cmd) {
        configuration.setComputationClass(WeightedPageRankComputation.class);
        int edgesClassOption = EDGES_CLASS.getOptionIntValue(cmd, 1);
        switch (edgesClassOption) {
            case 0: {
                configuration.setOutEdgesClass(LongDoubleArrayEdges.class);
                break;
            }
            case 1: {
                configuration.setOutEdgesClass(ByteArrayEdges.class);
                break;
            }
            case 2: {
                configuration.setOutEdgesClass(ByteArrayEdges.class);
                configuration.useUnsafeSerialization(true);
                break;
            }
            case 3: {
                configuration.setOutEdgesClass(ArrayListEdges.class);
                break;
            }
            case 4: {
                configuration.setOutEdgesClass(HashMapEdges.class);
                break;
            }
            default: {
                LOG.info((Object)"Unknown OutEdges class, defaulting to LongDoubleArrayEdges");
                configuration.setOutEdgesClass(LongDoubleArrayEdges.class);
            }
        }
        LOG.info((Object)("Using edges class " + GiraphConstants.VERTEX_EDGES_CLASS.get(configuration)));
        if (MESSAGE_COMBINER_TYPE.getOptionIntValue(cmd, 1) == 1) {
            configuration.setMessageCombinerClass(DoubleSumMessageCombiner.class);
        }
        if (EDGE_INPUT.optionTurnedOn(cmd)) {
            configuration.setEdgeInputFormatClass(PseudoRandomEdgeInputFormat.class);
        } else {
            configuration.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        }
        configuration.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionLongValue(cmd));
        configuration.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", BenchmarkOption.EDGES_PER_VERTEX.getOptionLongValue(cmd));
        configuration.setFloat("giraph.pseudoRandomInputFormat.localEdgesMinRatio", BenchmarkOption.LOCAL_EDGES_MIN_RATIO.getOptionFloatValue(cmd, 0.0f));
        if (OUTPUT_FORMAT.getOptionIntValue(cmd, -1) == 0) {
            LOG.info((Object)("Using vertex output format class " + JsonBase64VertexOutputFormat.class.getName()));
            configuration.setVertexOutputFormatClass(JsonBase64VertexOutputFormat.class);
        }
        if (PARTITIONER.getOptionIntValue(cmd, 0) == 1) {
            configuration.setGraphPartitionerFactoryClass(SimpleLongRangePartitionerFactory.class);
        }
        configuration.setInt("giraph.weightedPageRank.superstepCount", BenchmarkOption.SUPERSTEPS.getOptionIntValue(cmd));
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new WeightedPageRankBenchmark(), (String[])args));
    }
}

