/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

public class ShortestPathsComputation
extends BasicComputation<LongWritable, DoubleWritable, DoubleWritable, DoubleWritable> {
    public static final String SOURCE_ID = "giraph.shortestPathsBenchmark.sourceId";
    public static final long SOURCE_ID_DEFAULT = 1L;

    private boolean isSource(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex) {
        return vertex.getId().get() == this.getConf().getLong(SOURCE_ID, 1L);
    }

    @Override
    public void compute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        if (this.getSuperstep() == 0L) {
            vertex.setValue(new DoubleWritable(Double.MAX_VALUE));
        }
        double minDist = this.isSource(vertex) ? 0.0 : Double.MAX_VALUE;
        for (DoubleWritable doubleWritable : messages) {
            minDist = Math.min(minDist, doubleWritable.get());
        }
        if (minDist < vertex.getValue().get()) {
            vertex.setValue(new DoubleWritable(minDist));
            for (Edge edge : vertex.getEdges()) {
                double distance = minDist + ((DoubleWritable)edge.getValue()).get();
                this.sendMessage(edge.getTargetVertexId(), new DoubleWritable(distance));
            }
        }
        vertex.voteToHalt();
    }
}

