/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.benchmark.ShortestPathsComputation;
import org.apache.giraph.combiner.MinimumDoubleMessageCombiner;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.HashMapEdges;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class ShortestPathsBenchmark
extends GiraphBenchmark {
    private static final Logger LOG = Logger.getLogger(ShortestPathsBenchmark.class);
    private static final BenchmarkOption EDGES_CLASS = new BenchmarkOption("c", "edgesClass", true, "Vertex edges class (0 for HashMapEdges, 1 for ArrayListEdges)");
    private static final BenchmarkOption NO_COMBINER = new BenchmarkOption("nc", "noCombiner", false, "Don't use a combiner");

    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.VERTICES, BenchmarkOption.EDGES_PER_VERTEX, EDGES_CLASS, NO_COMBINER});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration conf, CommandLine cmd) {
        conf.setComputationClass(ShortestPathsComputation.class);
        if (EDGES_CLASS.getOptionIntValue(cmd, 1) == 1) {
            conf.setOutEdgesClass(ArrayListEdges.class);
        } else {
            conf.setOutEdgesClass(HashMapEdges.class);
        }
        LOG.info((Object)("Using class " + GiraphConstants.COMPUTATION_CLASS.get(conf)));
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        if (!NO_COMBINER.optionTurnedOn(cmd)) {
            conf.setMessageCombinerClass(MinimumDoubleMessageCombiner.class);
        }
        conf.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionLongValue(cmd));
        conf.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", BenchmarkOption.EDGES_PER_VERTEX.getOptionLongValue(cmd));
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new ShortestPathsBenchmark(), (String[])args));
    }
}

