/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.reducers.OnSameReduceOperation;
import org.apache.giraph.worker.DefaultWorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ReducersBenchmark
extends GiraphBenchmark {
    private static final String REDUCERS_NUM = "reducersbenchmark.num";
    private static final BenchmarkOption REDUCERS = new BenchmarkOption("r", "reducers", true, "Reducers", "Need to set number of reducers (-r)");

    private static int getNumReducers(Configuration conf) {
        return conf.getInt(REDUCERS_NUM, 0);
    }

    private static int getWorkerContextReduced(Configuration conf, long superstep) {
        return superstep <= 0L ? 0 : conf.getInt("workers", 0) * 3;
    }

    private static void assertEquals(long expected, long actual) {
        if (expected != actual) {
            throw new RuntimeException("expected: " + expected + ", actual: " + actual);
        }
    }

    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.VERTICES, REDUCERS});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration conf, CommandLine cmd) {
        conf.setComputationClass(ReducersBenchmarkComputation.class);
        conf.setMasterComputeClass(ReducersBenchmarkMasterCompute.class);
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        conf.setWorkerContextClass(ReducersBenchmarkWorkerContext.class);
        conf.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionLongValue(cmd));
        conf.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", 1L);
        conf.setInt(REDUCERS_NUM, REDUCERS.getOptionIntValue(cmd));
        conf.setInt("workers", conf.getInt("giraph.maxWorkers", -1));
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new ReducersBenchmark(), (String[])args));
    }

    public static class ReducersBenchmarkWorkerContext
    extends DefaultWorkerContext {
        @Override
        public void preSuperstep() {
            this.addToWorkerReducers(1);
            this.checkReducers();
        }

        @Override
        public void postSuperstep() {
            this.addToWorkerReducers(2);
            this.checkReducers();
        }

        private void checkReducers() {
            int n = ReducersBenchmark.getNumReducers(this.getContext().getConfiguration());
            long superstep = this.getSuperstep();
            int w = ReducersBenchmark.getWorkerContextReduced(this.getContext().getConfiguration(), superstep);
            for (int i = 0; i < n; ++i) {
                if (superstep <= 0L) continue;
                ReducersBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getBroadcast("w" + i)).get());
                ReducersBenchmark.assertEquals(-(superstep * (long)i), ((LongWritable)this.getBroadcast("m" + i)).get());
                ReducersBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getBroadcast("p" + i)).get());
            }
        }

        private void addToWorkerReducers(int valueToAdd) {
            int n = ReducersBenchmark.getNumReducers(this.getContext().getConfiguration());
            for (int i = 0; i < n; ++i) {
                this.reduce("w" + i, new LongWritable((long)valueToAdd));
            }
        }
    }

    public static class ReducersBenchmarkMasterCompute
    extends DefaultMasterCompute {
        @Override
        public void compute() {
            int n = ReducersBenchmark.getNumReducers(this.getConf());
            long superstep = this.getSuperstep();
            int w = ReducersBenchmark.getWorkerContextReduced(this.getConf(), superstep);
            for (int i = 0; i < n; ++i) {
                String wi = "w" + i;
                String mi = "m" + i;
                String pi = "p" + i;
                this.registerReduce(wi, TestLongSumReducer.INSTANCE);
                this.registerReduce(mi, new TestLongSumReducer());
                if (superstep > 0L) {
                    this.broadcast(wi, (Writable)this.getReduced(wi));
                    this.broadcast(mi, (Writable)new LongWritable(-superstep * (long)i));
                    this.broadcast(pi, (Writable)this.getReduced(pi));
                    this.registerReduce(pi, new TestLongSumReducer(), (LongWritable)this.getReduced(pi));
                    ReducersBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getReduced(wi)).get());
                    ReducersBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getReduced(pi)).get());
                    continue;
                }
                this.registerReduce(pi, new TestLongSumReducer());
            }
        }
    }

    public static class ReducersBenchmarkComputation
    extends BasicComputation<LongWritable, DoubleWritable, DoubleWritable, DoubleWritable> {
        @Override
        public void compute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
            int n = ReducersBenchmark.getNumReducers(this.getConf());
            long superstep = this.getSuperstep();
            int w = ReducersBenchmark.getWorkerContextReduced(this.getConf(), superstep);
            for (int i = 0; i < n; ++i) {
                this.reduce("w" + i, new LongWritable((superstep + 1L) * (long)i));
                this.reduce("p" + i, new LongWritable((long)i));
                if (superstep <= 0L) continue;
                ReducersBenchmark.assertEquals(superstep * (this.getTotalNumVertices() * (long)i) + (long)w, ((LongWritable)this.getBroadcast("w" + i)).get());
                ReducersBenchmark.assertEquals(-(superstep * (long)i), ((LongWritable)this.getBroadcast("m" + i)).get());
                ReducersBenchmark.assertEquals(superstep * this.getTotalNumVertices() * (long)i, ((LongWritable)this.getBroadcast("p" + i)).get());
            }
            if (superstep > 2L) {
                vertex.voteToHalt();
            }
        }
    }

    public static class TestLongSumReducer
    extends OnSameReduceOperation<LongWritable> {
        public static final TestLongSumReducer INSTANCE = new TestLongSumReducer();

        @Override
        public LongWritable createInitialValue() {
            return new LongWritable();
        }

        @Override
        public LongWritable reduceSingle(LongWritable curValue, LongWritable valueToReduce) {
            curValue.set(curValue.get() + valueToReduce.get());
            return curValue;
        }

        public void readFields(DataInput in) throws IOException {
        }

        public void write(DataOutput out) throws IOException {
        }
    }
}

