/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.benchmark;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.giraph.benchmark.BenchmarkOption;
import org.apache.giraph.benchmark.GiraphBenchmark;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Logger;

public class RandomMessageBenchmark
extends GiraphBenchmark {
    public static final String SUPERSTEP_COUNT = "giraph.randomMessageBenchmark.superstepCount";
    public static final String NUM_BYTES_PER_MESSAGE = "giraph.randomMessageBenchmark.numBytesPerMessage";
    public static final int DEFAULT_NUM_BYTES_PER_MESSAGE = 16;
    public static final String NUM_MESSAGES_PER_EDGE = "giraph.randomMessageBenchmark.numMessagesPerEdge";
    public static final int DEFAULT_NUM_MESSAGES_PER_EDGE = 1;
    public static final String AGG_SUPERSTEP_TOTAL_BYTES = "superstep total bytes sent";
    public static final String AGG_TOTAL_BYTES = "total bytes sent";
    public static final String AGG_SUPERSTEP_TOTAL_MESSAGES = "superstep total messages";
    public static final String AGG_TOTAL_MESSAGES = "total messages";
    public static final String AGG_SUPERSTEP_TOTAL_MILLIS = "superstep total millis";
    public static final String AGG_TOTAL_MILLIS = "total millis";
    public static final String WORKERS_NUM = "workers";
    private static final BenchmarkOption BYTES_PER_MESSAGE = new BenchmarkOption("b", "bytes", true, "Message bytes per memssage", "Need to set the number of message bytes (-b)");
    private static final BenchmarkOption MESSAGES_PER_EDGE = new BenchmarkOption("n", "number", true, "Number of messages per edge", "Need to set the number of messages per edge (-n)");
    private static final BenchmarkOption FLUSH_THREADS = new BenchmarkOption("f", "flusher", true, "Number of flush threads");
    private static final Logger LOG = Logger.getLogger(RandomMessageBenchmarkWorkerContext.class);

    @Override
    public Set<BenchmarkOption> getBenchmarkOptions() {
        return Sets.newHashSet((Object[])new BenchmarkOption[]{BenchmarkOption.SUPERSTEPS, BenchmarkOption.VERTICES, BenchmarkOption.EDGES_PER_VERTEX, BYTES_PER_MESSAGE, MESSAGES_PER_EDGE, FLUSH_THREADS});
    }

    @Override
    protected void prepareConfiguration(GiraphConfiguration conf, CommandLine cmd) {
        conf.setComputationClass(RandomMessageComputation.class);
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        conf.setWorkerContextClass(RandomMessageBenchmarkWorkerContext.class);
        conf.setMasterComputeClass(RandomMessageBenchmarkMasterCompute.class);
        conf.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", BenchmarkOption.VERTICES.getOptionLongValue(cmd));
        conf.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", BenchmarkOption.EDGES_PER_VERTEX.getOptionLongValue(cmd));
        conf.setInt(SUPERSTEP_COUNT, BenchmarkOption.SUPERSTEPS.getOptionIntValue(cmd));
        conf.setInt(NUM_BYTES_PER_MESSAGE, BYTES_PER_MESSAGE.getOptionIntValue(cmd));
        conf.setInt(NUM_MESSAGES_PER_EDGE, MESSAGES_PER_EDGE.getOptionIntValue(cmd));
        if (FLUSH_THREADS.optionTurnedOn(cmd)) {
            conf.setInt("giraph.msgNumFlushThreads", FLUSH_THREADS.getOptionIntValue(cmd));
        }
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new RandomMessageBenchmark(), (String[])args));
    }

    public static class RandomMessageComputation
    extends BasicComputation<LongWritable, DoubleWritable, DoubleWritable, BytesWritable> {
        @Override
        public void compute(Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex, Iterable<BytesWritable> messages) throws IOException {
            RandomMessageBenchmarkWorkerContext workerContext = (RandomMessageBenchmarkWorkerContext)this.getWorkerContext();
            if (this.getSuperstep() < (long)workerContext.getNumSupersteps()) {
                for (int i = 0; i < workerContext.getNumMessagePerEdge(); ++i) {
                    workerContext.randomizeMessageBytes();
                    this.sendMessageToAllEdges(vertex, new BytesWritable(workerContext.getMessageBytes()));
                    long bytesSent = workerContext.getMessageBytes().length * vertex.getNumEdges();
                    this.aggregate(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_BYTES, new LongWritable(bytesSent));
                    this.aggregate(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MESSAGES, new LongWritable((long)vertex.getNumEdges()));
                }
            } else {
                vertex.voteToHalt();
            }
        }
    }

    public static class RandomMessageBenchmarkMasterCompute
    extends DefaultMasterCompute {
        @Override
        public void initialize() throws InstantiationException, IllegalAccessException {
            this.registerAggregator(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_BYTES, LongSumAggregator.class);
            this.registerAggregator(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MESSAGES, LongSumAggregator.class);
            this.registerAggregator(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MILLIS, LongSumAggregator.class);
            this.registerAggregator(RandomMessageBenchmark.WORKERS_NUM, LongSumAggregator.class);
        }
    }

    public static class RandomMessageBenchmarkWorkerContext
    extends WorkerContext {
        private static final Logger LOG = Logger.getLogger(RandomMessageBenchmarkWorkerContext.class);
        private byte[] messageBytes;
        private int numMessagesPerEdge = -1;
        private int numSupersteps = -1;
        private final Random random = new Random(System.currentTimeMillis());
        private long startSuperstepMillis = 0L;
        private long totalBytes = 0L;
        private long totalMessages = 0L;
        private long totalMillis = 0L;

        @Override
        public void preApplication() throws InstantiationException, IllegalAccessException {
            this.messageBytes = new byte[this.getContext().getConfiguration().getInt(RandomMessageBenchmark.NUM_BYTES_PER_MESSAGE, 16)];
            this.numMessagesPerEdge = this.getContext().getConfiguration().getInt(RandomMessageBenchmark.NUM_MESSAGES_PER_EDGE, 1);
            this.numSupersteps = this.getContext().getConfiguration().getInt(RandomMessageBenchmark.SUPERSTEP_COUNT, -1);
        }

        @Override
        public void preSuperstep() {
            long superstepBytes = ((LongWritable)this.getAggregatedValue(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_BYTES)).get();
            long superstepMessages = ((LongWritable)this.getAggregatedValue(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MESSAGES)).get();
            long superstepMillis = ((LongWritable)this.getAggregatedValue(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MILLIS)).get();
            long workers = ((LongWritable)this.getAggregatedValue(RandomMessageBenchmark.WORKERS_NUM)).get();
            if (this.getSuperstep() == 0L) {
                this.startSuperstepMillis = System.currentTimeMillis();
            } else {
                this.totalBytes += superstepBytes;
                this.totalMessages += superstepMessages;
                this.totalMillis += superstepMillis;
                double superstepMegabytesPerSecond = (double)(superstepBytes * workers) * 1000.0 / 1024.0 / 1024.0 / (double)superstepMillis;
                double megabytesPerSecond = (double)(this.totalBytes * workers) * 1000.0 / 1024.0 / 1024.0 / (double)this.totalMillis;
                double superstepMessagesPerSecond = (double)(superstepMessages * workers) * 1000.0 / (double)superstepMillis;
                double messagesPerSecond = (double)(this.totalMessages * workers) * 1000.0 / (double)this.totalMillis;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Outputing statistics for superstep " + this.getSuperstep()));
                    LOG.info((Object)("superstep total bytes sent : " + superstepBytes));
                    LOG.info((Object)("total bytes sent : " + this.totalBytes));
                    LOG.info((Object)("superstep total messages : " + superstepMessages));
                    LOG.info((Object)("total messages : " + this.totalMessages));
                    LOG.info((Object)("superstep total millis : " + superstepMillis));
                    LOG.info((Object)("total millis : " + this.totalMillis));
                    LOG.info((Object)("workers : " + workers));
                    LOG.info((Object)("Superstep megabytes / second = " + superstepMegabytesPerSecond));
                    LOG.info((Object)("Total megabytes / second = " + megabytesPerSecond));
                    LOG.info((Object)("Superstep messages / second = " + superstepMessagesPerSecond));
                    LOG.info((Object)("Total messages / second = " + messagesPerSecond));
                    LOG.info((Object)("Superstep megabytes / second / worker = " + superstepMegabytesPerSecond / (double)workers));
                    LOG.info((Object)("Total megabytes / second / worker = " + megabytesPerSecond / (double)workers));
                    LOG.info((Object)("Superstep messages / second / worker = " + superstepMessagesPerSecond / (double)workers));
                    LOG.info((Object)("Total messages / second / worker = " + messagesPerSecond / (double)workers));
                }
            }
            this.aggregate(RandomMessageBenchmark.WORKERS_NUM, new LongWritable(1L));
        }

        @Override
        public void postSuperstep() {
            long endSuperstepMillis = System.currentTimeMillis();
            long superstepMillis = endSuperstepMillis - this.startSuperstepMillis;
            this.startSuperstepMillis = endSuperstepMillis;
            this.aggregate(RandomMessageBenchmark.AGG_SUPERSTEP_TOTAL_MILLIS, new LongWritable(superstepMillis));
        }

        @Override
        public void postApplication() {
        }

        public byte[] getMessageBytes() {
            return this.messageBytes;
        }

        public int getNumMessagePerEdge() {
            return this.numMessagesPerEdge;
        }

        public int getNumSupersteps() {
            return this.numSupersteps;
        }

        public void randomizeMessageBytes() {
            this.random.nextBytes(this.messageBytes);
        }
    }
}

